% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_colour_assignment.R
\name{print_colour_assignment}
\alias{print_colour_assignment}
\title{Prints a summary table of results from the different criteria}
\usage{
print_colour_assignment(Name, Threshold, Radii, first = 'n', number_sites = -1)
}
\arguments{
\item{Name}{name of the data, which is used for any saved files and plot titles}

\item{Threshold}{threshold value}

\item{Radii}{set of radius values}

\item{first}{if \code{'y'}, the algorithm will look for the second greatest maximum percent drop if the first results in the first circle being the only non-identified site}

\item{number_sites}{number of sites to manually show the results for}
}
\value{
Summary table of the colour assignment part of the algorithm.
}
\description{
Prints a summary of the results from using the stability criterion and threshold criterion as well as the colour assigned.
}
\details{
This function prints a clear summary of the results from using both the stability and threshold criteria, including the maximum percent drop and number of identified sites. The threshold criterion requires that the maximum percent drop must be greater than a given value (\code{Threshold}) and also be a local maximum. The stability criterion requires again that the maximum percent drop be a local maximum and also that the radius values either side, result in the same number of sites identified.

The colour assigned is also printed, where Green is assigned if the two criteria result in the same radius, Amber is assigned if the number of sites are the same for the two criteria, but not the same radius and Red is assigned if the number of sites are different. This gives a qualitative level of confidence in the results produced.
}
\examples{
\donttest{##Find the current working directory
wd = getwd()
##Set the working directory as the temporary one
setwd(tempdir())
##Load the data
data(OU_14)
t=unlist(OU_14["t"])
X=unlist(OU_14["X"])
Y=unlist(OU_14["Y"])

##Run the algorithm for multiple radius values
Radii=seq(0.2,1.0,0.1)
for (R in Radii){
  Alt_Alg("OU_14",t,X,Y,R,first='y',save='y')}

##Print a summary table of the results from the two criteria and the colour assigned
print_colour_assignment("OU_14",65,Radii,first='y')

##Reset the original working directory
setwd(wd)}
}
\references{
Munden, R., Borger , L., Wilson, R.P., Redcliffe, J., Loison, A., Garel, M. and Potts, J.P. in review. Making sense of ultra-high-resolution movement data: an algorithm for inferring sites of interest.
}
\seealso{
See also \code{\link{Alt_Alg}} to find the residence times. \code{\link{Sites}} can be used to find the maximum percent drop and number of sites of interest from the csv files produced by \code{\link{Alt_Alg}}.
}
\author{
Rhys Munden <rdmunden1@sheffield.ac.uk>
}
\keyword{Printed_summary}
