% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/functions.R
\name{as.row.leaves}
\alias{as.row.leaves}
\title{Get leaf matrix}
\usage{
as.row.leaves(term.descendancy.matrix, terms.matrix)
}
\arguments{
\item{term.descendancy.matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO)}

\item{terms.matrix}{The character matrix of HPO terms}
}
\value{
Logical matrix the same dimensions as the terms.matrix which indicates whethere each element is a leaf or not
}
\description{
Procure logical matrix from character matrix of HPO terms, indicating whether each element is a leaf in the context of the row. Typically used on the output of the \code{\link{sim.reg}}.
}
\examples{
data(hpo.terms)
as.row.leaves(
	get.term.descendancy.matrix(hpo.terms, c("HP:0001873", "HP:0001872")),
	matrix(c("HP:0001873","HP:0001872","HP:0001873","HP:0001872"),2,2)
)
}

