% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mparse.R
\name{mparse}
\alias{mparse}
\title{Model parser to define new models to run in \code{SimInf}}
\usage{
mparse(
  transitions = NULL,
  compartments = NULL,
  ldata = NULL,
  gdata = NULL,
  u0 = NULL,
  v0 = NULL,
  tspan = NULL,
  events = NULL,
  E = NULL,
  N = NULL,
  pts_fun = NULL
)
}
\arguments{
\item{transitions}{character vector containing transitions on the
form \code{"X -> ... -> Y"}. The left (right) side is the
initial (final) state and the propensity is written in between
the \code{->}-signs. The special symbol \code{@} is reserved
for the empty set. For example, \code{transitions =
c("S -> k1*S*I -> I", "I -> k2*I -> R")} expresses a SIR
model.}

\item{compartments}{contains the names of the involved
compartments, for example, \code{compartments = c("S", "I",
"R")}.}

\item{ldata}{optional data for the nodes. Can be specified either
as a numeric matrix where column \code{ldata[, j]} contains
the local data vector for the node \code{j} or as a
\code{data.frame} with one row per node. If it's specified as
a matrix, it must have row names to identify the parameters in
the transitions. If it's specified as a data.frame, each
column is one parameter. The local data vector is passed as an
argument to the transition rate functions and the post time
step function.}

\item{gdata}{optional data that are common to all nodes in the
model. Can be specified either as a named numeric vector or as
as a one-row data.frame. The names are used to identify the
parameters in the transitions. The global data vector is
passed as an argument to the transition rate functions and the
post time step function.}

\item{u0}{A \code{data.frame} (or an object that can be coerced to
a \code{data.frame} with \code{as.data.frame}) with the
initial state i.e. the number of individuals in each
compartment in each node when the simulation starts..}

\item{v0}{optional data with the initial continuous state in each
node. Can be specified either as a \code{data.frame} with one
row per node or as a numeric matrix where column \code{v0[,
j]} contains the initial state vector for the node
\code{j}. If \code{v0} is specified as a \code{data.frame},
each column is one parameter. If \code{v0} is specified as a
matrix, the row names identify the parameters. The 'v' vector
is passed as an argument to the transition rate functions and
the post time step function. The continuous state can be
updated in the post time step function.}

\item{tspan}{A vector (length >= 1) of increasing time points
where the state of each node is to be returned. Can be either
an \code{integer} or a \code{Date} vector. A \code{Date}
vector is coerced to a numeric vector as days, where
\code{tspan[1]} becomes the day of the year of the first year
of \code{tspan}. The dates are added as names to the numeric
vector.}

\item{events}{A \code{data.frame} with the scheduled
events. Default is \code{NULL} i.e. no scheduled events in the
model.}

\item{E}{matrix to handle scheduled events, see
\code{\linkS4class{SimInf_events}}. Default is \code{NULL}
i.e. no scheduled events in the model.}

\item{N}{matrix to handle scheduled events, see
\code{\linkS4class{SimInf_events}}. Default is \code{NULL}
i.e. no scheduled events in the model.}

\item{pts_fun}{optional character vector with C code for the post
time step function. The C code should contain only the body of
the function i.e. the code between the opening and closing
curly brackets.}
}
\value{
a \code{\linkS4class{SimInf_model}} object
}
\description{
Describe your model in a logical way in R. \code{mparse} creates a
\code{\linkS4class{SimInf_model}} object with your model
definition that is ready to \code{\link{run}}.
}
\examples{
\dontrun{
## Use the model parser to create a 'SimInf_model' object that
## expresses an SIR model, where 'beta' is the transmission rate
## and 'gamma' is the recovery rate.
model  <- mparse(transitions = c("S -> beta*S*I/(S+I+R) -> I",
                                 "I -> gamma*I -> R"),
                 compartments = c("S", "I", "R"),
                 gdata = c(beta = 0.16, gamma = 0.077),
                 u0 = data.frame(S = 100, I = 1, R = 0),
                 tspan = 1:100)

## Run and plot the result
set.seed(22)
result <- run(model)
plot(result)
}
}
