% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siminf_model.R
\docType{class}
\name{siminf_model-class}
\alias{siminf_model-class}
\title{Class \code{"siminf_model"}}
\description{
Class to handle the siminf data model
}
\section{Slots}{

\describe{
  \item{G}{
    Dependency graph that indicates the transition rates that need
    to be updated after a given state transition has occured.
    A non-zero entry in element \code{G[i, i]} indicates that transition
    rate \code{i} needs to be recalculated if the state transition
    \code{j} occurs. Sparse matrix (\eqn{Nt \times Nt}) of object class
    \code{"\linkS4class{dgCMatrix}"}.
  }
  \item{S}{
    Each column corresponds to a state transition, and execution
    of state transition \code{j} amounts to adding the \code{S[,
    j]} column to the state vector \code{u[, i]} of node \emph{i}
    where the transition occurred. Sparse matrix (\eqn{Nc \times
    Nt}) of object class \code{"\linkS4class{dgCMatrix}"}.
  }
  \item{U}{
    The result matrix with the number of individuals in each
    compartment in every node. \code{U[, j]} contains the number
    of individuals in each compartment at
    \code{tspan[j]}. \code{U[1:Nc, j]} contains the number of
    individuals in node 1 at \code{tspan[j]}. \code{U[(Nc + 1):(2
    * Nc), j]} contains the number of individuals in node 2 at
    \code{tspan[j]} etc. Integer matrix (\eqn{N_n N_c \times}
    \code{length(tspan)}).
  }
  \item{V}{
    The result matrix for the real-valued continous
    state. \code{V[, j]} contains the real-valued state of the
    system at \code{tspan[j]}. Numeric matrix
    (\eqn{N_n}\code{dim(ldata)[1]} \eqn{\times}
    \code{length(tspan)}).
  }
  \item{ldata}{
    A matrix with local data for the nodes. The column \code{ldata[, j]}
    contains the local data vector for the node \code{j}. The local
    data vector is passed as an argument to the transition rate
    functions and the post time step function.
  }
  \item{gdata}{
    A numeric vector with global data that is common to all nodes.
    The global data vector is passed as an argument to the
    transition rate functions and the post time step function.
  }
  \item{sd}{
    Each node can be assigned to a sub-domain.
    Integer vector of length \code{Nn}.
  }
  \item{tspan}{
    A vector of increasing time points where the state of each node is
    to be returned.
  }
  \item{u0}{
    The initial state vector (\eqn{N_c \times N_n}) with
    the number of individuals in each compartment in every node.
  }
  \item{v0}{
     The initial value for the real-valued continuous state.
     Numeric matrix (\code{dim(ldata)[1]} \eqn{\times N_n}).
  }
  \item{events}{
    Scheduled events \code{"\linkS4class{scheduled_events}"}
  }
}
}
\keyword{methods}

