% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{prevalence,SimInf_pmcmc-method}
\alias{prevalence,SimInf_pmcmc-method}
\title{Extract prevalence from fitting a PMCMC algorithm}
\usage{
\S4method{prevalence}{SimInf_pmcmc}(model, formula, level, index, start = 1, end = NULL, thin = 1)
}
\arguments{
\item{model}{the \code{SimInf_pmcmc} object to extract the
prevalence from.}

\item{formula}{A formula that specifies the compartments that
define the cases with a disease or that have a specific
characteristic (numerator), and the compartments that define
the entire population of interest (denominator). The
left-hand-side of the formula defines the cases, and the
right-hand-side defines the population, for example,
\code{I~S+I+R} in a \sQuote{SIR} model (see
\sQuote{Examples}). The \code{.}  (dot) is expanded to all
compartments, for example, \code{I~.}  is expanded to
\code{I~S+I+R} in a \sQuote{SIR} model (see
\sQuote{Examples}). The formula can also contain a condition
(indicated by \code{|}) for each node and time step to further
control the population to include in the calculation, for
example, \code{I ~ . | R == 0} to calculate the prevalence
when the recovered is zero in a \sQuote{SIR} model. The
condition must evaluate to \code{TRUE} or \code{FALSE} in each
node and time step. Please note, if the denominator is zero,
the prevalence is \code{NaN}. Additionally, when
\code{level=3} (within-node prevalence) and the formula
contains a condition that evaluates to \code{FALSE}, the
prevalence is also \code{NaN}.}

\item{level}{The level at which the prevalence is calculated at
each time point in \code{tspan}. 1 (population prevalence):
calculates the proportion of the individuals (cases) in the
population. 2 (node prevalence): calculates the proportion of
nodes with at least one case. 3 (within-node prevalence):
calculates the proportion of cases within each node. Default
is \code{1}.}

\item{index}{indices specifying the subset of nodes to include
when extracting data. Default (\code{index = NULL}) is to
extract data from all nodes.}

\item{start}{The start iteration to remove some burn-in
iterations. Default is \code{start = 1}.}

\item{end}{the last iteration to include. Default is \code{NULL}
which set \code{end} to the last iteration in the chain.}

\item{thin}{keep every \code{thin} iteration after the
\code{start} iteration. Default is \code{thin = 1}, i.e., keep
every iteration.}
}
\value{
A \code{data.frame} where the first column is the
    \code{iteration} and the remaining columns are the result from
    calling \code{\link{prevalence,SimInf_model-method}} with the
    arguments \code{formula}, \code{level} and \code{index} for
    each iteration.
}
\description{
Extract prevalence from the filtered trajectories from a particle
Markov chain Monte Carlo algorithm.
}
