% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.beta.accurate.R
\name{is.beta.accurate}
\alias{is.beta.accurate}
\title{Verification of beta matrix accuracy}
\usage{
is.beta.accurate(beta_fun, n_fun, correl_fun)
}
\arguments{
\item{beta_fun}{Numeric matrix of co-regulation coefficients}

\item{n_fun}{Number of enzymes in the system}

\item{correl_fun}{Character string indicating the constraint applied on the system}
}
\value{
Return \code{TRUE} if all conditions are respected, else stop
}
\description{
Verifies if the the matrix \code{beta_fun} of co-regulation coefficients is accurate for other functions
}
\details{
Different tests are performed on matrix \code{beta_fun} to verify its accuracy.

\itemize{
   \item Is there regulation in \code{correl_fun}? If yes, \code{beta_fun} is necessary.
   \item Does \code{beta_fun} have a correct size? Compare \code{nrow(beta_fun)} and \code{ncol(beta_fun)} to number of enzymes \code{n_fun}. If difference, stops.
   \item Is there negative regulation in \code{correl_fun}? If yes, does \code{beta_fun} include a negative regulation?  If difference, stops.
   \item Each element of \code{beta_fun} diagonal needs to be equal to 1.
   }
}
\examples{

beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
is.beta.accurate(beta,3,"CRPos")


}
\seealso{
To verify vector of global co-regulation coefficients, see function \code{\link{is.B.accurate}}.
}
