% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_sel.discrete.R
\name{coef_sel.discrete}
\alias{coef_sel.discrete}
\title{Selection coefficient computation}
\usage{
coef_sel.discrete(E_res, A_res, E_mut=NULL, A_mut=NULL)
}
\arguments{
\item{E_res}{Numeric vector of concentrations for the resident}

\item{A_res}{Numeric vector of activities for the resident.
Default value \code{NULL} corresponds to no mutation, \emph{i.e.} same value as \code{E_res}}

\item{E_mut}{Numeric vector of concentrations for the mutant}

\item{A_mut}{Numeric vector of activities for the mutant.
Default value \code{NULL} corresponds to no mutation, \emph{i.e.} same value as \code{A_res}}
}
\value{
Numeric value for selection coefficient
}
\description{
Computes the selection coefficient using the discrete expression \eqn{s = (w^m - w^r)/w^r}
}
\details{
Computes the selection coefficient between mutant and resident using the discrete expression \eqn{s = (w^m - w^r)/w^r},
assuming that fitness is proportional to flux.
Here, function \code{\link{flux}} is used to compute the flux, and therefore, the fitness.

All input vectors need to have the same length.

If there is no mutation affecting concentrations (resp. activities), 
mutant concentrations (resp. activities) are identical to resident one.
In this case, give to \code{E_mut} (resp. \code{A_fun}) the same value as \code{E_res} (resp. \code{A_res}), 
or put the default value \code{NULL}.
}
\examples{

### Mutation of E
A <- c(1,10,30)
E <- c(30,30,30)
Em <- mut.E.direct(E,1,1,"SC")

coef_sel.discrete(E,A,Em)


### Mutation of A
E <- c(30,30,30)
kin <- c(1,10,1000)
Keq <- c(10,1,100)
A <- activities(kin,Keq)
kin_m <- mut.kin(kin,3,1)
Am <- activities(kin_m,Keq) #equilibrium constant cannot be modified by mutation

coef_sel.discrete(E,A,E,Am)


}
\seealso{
Use function \code{\link{activities}} to compute enzyme activities.
}
