% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimClean.R
\name{SimClean}
\alias{SimClean}
\title{Removes/cleans files and folders that have been saved}
\usage{
SimClean(..., dirs = NULL, generate_data = FALSE, results = FALSE,
  seeds = FALSE, temp = FALSE, save_details = list())
}
\arguments{
\item{...}{one or more character objects indicating which files to remove. Used to remove
\code{.rds} files which were saved with \code{\link{saveRDS}} or when using the \code{save}
and \code{filename} inputs to \code{\link{runSimulation}}}

\item{dirs}{a character vector indicating which directories to remove}

\item{generate_data}{logical; remove the \code{.rds} data-set files
saved when passing \code{save_generate_data = TRUE}?}

\item{results}{logical; remove the \code{.rds} results files
saved when passing \code{save_results = TRUE}?}

\item{seeds}{logical; remove the seed files
saved when passing \code{save_seeds = TRUE}?}

\item{temp}{logical; remove the temporary file saved when passing \code{save = TRUE}?}

\item{save_details}{a list pertaining to information about how and where files were saved
(see the corresponding list in \code{\link{runSimulation}})}
}
\description{
This function is mainly used in pilot studies where results and datasets have been temporarily saved
by \code{\link{runSimulation}} but should be removed before beginning the full
Monte Carlo simulation (e.g., remove files and folders which contained bugs/biased results).
}
\examples{
\dontrun{

# remove file called 'results.rds'
SimClean('results.rds')

# remove default temp file
SimClean(temp = TRUE)

# remove default saved-data directory
SimClean(generate_data = TRUE)

# remove customized saved-results directory called 'mydir'
SimClean(results = TRUE, save_details = list(save_results_dirname = 'mydir'))

}
}
\seealso{
\code{\link{runSimulation}}
}

