% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{RegionHeatmap}
\alias{RegionHeatmap}
\title{Region heatmap}
\usage{
RegionHeatmap(
  object,
  key,
  assay = NULL,
  idents = NULL,
  normalize = TRUE,
  upstream = 3000,
  downstream = 3000,
  max.cutoff = "q95",
  cols = NULL,
  min.counts = 1,
  window = (upstream + downstream)/30,
  order = TRUE,
  nrow = NULL
)
}
\arguments{
\item{object}{A Seurat object}

\item{key}{Name of key to pull data from. Stores the results from
\code{\link{RegionMatrix}}}

\item{assay}{Name of assay to use. If a list or vector of assay names is
given, data will be plotted from each assay. Note that all assays must
contain \code{RegionMatrix} results with the same key. Sorting will be 
defined by the first assay in the list}

\item{idents}{Cell identities to include. Note that cells cannot be
regrouped, this will require re-running \code{RegionMatrix} to generate a 
new set of matrices}

\item{normalize}{Normalize by number of cells in each group}

\item{upstream}{Number of bases to include upstream of region. If NULL, use
all bases that were included in the \code{RegionMatrix} function call. Note
that this value cannot be larger than the value for \code{upstream} given in
the original \code{RegionMatrix} function call. If NULL, use parameters that
were given in the \code{RegionMatrix} function call}

\item{downstream}{Number of bases to include downstream of region. See
documentation for \code{upstream}}

\item{max.cutoff}{Maximum cutoff value. Data above this value will be clipped
to the maximum value. A quantile maximum can be specified in the form of 
"q##" where "##" is the quantile (eg, "q90" for 90th quantile). If NULL, no
cutoff will be set}

\item{cols}{Vector of colors to use as the maximum value of the color scale.
One color must be supplied for each assay. If NULL, the default ggplot2
colors are used.}

\item{min.counts}{Minimum total counts to display region in plot}

\item{window}{Smoothing window to apply}

\item{order}{Order regions by the total number of fragments in the region
across all included identities}

\item{nrow}{Number of rows to use when creating plot. If NULL, chosen
automatically by ggplot2}
}
\value{
Returns a ggplot2 object
}
\description{
Plot fragment counts within a set of regions.
}
\seealso{
RegionMatrix
}
\concept{heatmap}
\concept{visualization}
