% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blis.R
\name{obtain_nrm_def}
\alias{obtain_nrm_def}
\title{Obtain model definition for \code{mirt}'s nominal model taking in account the key
of correct answers}
\usage{
obtain_nrm_def(data_with_key, ...)
}
\arguments{
\item{data_with_key}{The output of \code{nominal_to_int()}.}

\item{...}{arguments passed onto \code{mirt::mirt()}. No practical use for now.}
}
\value{
A \code{data.frame} with the starting values, parameter numbers,
estimation constrains etc. Pass it as \code{pars} argument of \code{\link[mirt:mirt]{mirt::mirt()}}.
}
\description{
Standard \code{mirt} model with \code{itemtype = "nominal"} puts the
identification constrains on the item response category slopes such as
\eqn{ak_0 = 0} and \eqn{ak_{(K-1)} = (K - 1)}, freely estimating the rest.

While nominal item responses are unordered by definition, it is often the
case that one of the item response categories is correct and the
respondents endorsing this category "naturally" possess a higher latent
ability. Use this function to obtain model definition where the correct
response category \eqn{k_c} for item \eqn{i} with \eqn{K} possible response
categories translates to constrains \eqn{ak_{k_c} = (K - 1)} and
\eqn{ak_{k_{d1}} = 0}, with \eqn{k_{d1}} being the first incorrect response
category (i.e. the first distractor).
}
\examples{
library(mirt)

# convert nominal data to integers and the original labels with correct answers
data_with_key <- nominal_to_int(HCItest[, 1:20], HCIkey)

# build model definition for {mirt} using the returned list from above
nrm_def <- obtain_nrm_def(data_with_key)

# fit the nominal model using the obtained model definition in `pars` argument
fit <- mirt(data_with_key$Data, 1, "nominal", pars = nrm_def)
}
\seealso{
Other BLIS/BLIRT related: 
\code{\link{BlisClass-class}},
\code{\link{coef,BlisClass-method}},
\code{\link{fit_blis}()},
\code{\link{get_orig_levels}()},
\code{\link{nominal_to_int}()},
\code{\link{print.blis_coefs}()}
}
\concept{BLIS/BLIRT related}
