% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_parallel.R
\encoding{UTF-8}
\name{fa_parallel}
\alias{fa_parallel}
\title{Conduct Parallel Analysis}
\usage{
fa_parallel(
  Data,
  cor = "pearson",
  n_obs = NULL,
  method = "pca",
  threshold = "quantile",
  p = 0.95,
  n_iter = 20,
  plot = TRUE,
  show_kaiser = TRUE,
  fm = "minres",
  use = "pairwise",
  ...
)
}
\arguments{
\item{Data}{\emph{data.frame} or \emph{matrix}, dataset (where rows are
observations and columns items) or correlation matrix (recognized
automatically).}

\item{cor}{\emph{character}, how to calculate the correlation matrix of the
real data. Can be either \code{pearson} (default), \code{tetrachoric} or
\code{polychoric}. Unambiguous abbreviations accepted.}

\item{n_obs}{\emph{integer}, in case you provided the correlation matrix
directly as the input, you have to provide the number of observations in
the original dataset.}

\item{method}{\emph{character}, either \code{fa}, \code{pca}, or \code{both}
(the default). Which method to use for the eigenvalues simulation and
computation.}

\item{threshold}{\emph{character}, whether to use traditionall Horn's method
or more recent and well-performing quantile one. Either \code{mean} or
\code{quantile} (default). Can be abbreviated.}

\item{p}{\emph{numeric} (0--1), probability for which the sample quantile is
produced. Defaults to \code{.95}. Ignored if \code{threshold = "mean"}.}

\item{n_iter}{\emph{integer}, number of iterations, i.e. the number of
zero-factor multivariate normal distributions to sample. Defaults to
\code{20}.}

\item{plot}{\emph{logical}, if \code{TRUE} (the default), show the plot along
with the function results. To create the plot from the resulting object
afterwards, call \code{plot()}.}

\item{show_kaiser}{\emph{logical}, whether to show Kaiser boundary in the
plot (the default) or not.}

\item{fm}{\emph{character}, factoring method. See \code{\link[psych]{fa}}
from the package \code{\link[psych]{psych}}.}

\item{use}{an optional character string giving a
    method for computing covariances in the presence
    of missing values.  This must be (an abbreviation of) one of the strings
    \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
    \code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}

\item{...}{
  Arguments passed on to \code{\link[psych:tetrachor]{psych::polychoric}}
  \describe{
    \item{\code{correct}}{Correction value to use to correct for continuity in the case of zero entry cell for tetrachoric, polychoric, polybi, and mixed.cor.  See the examples for the effect of correcting versus not correcting for continuity.}
    \item{\code{smooth}}{if TRUE and if the tetrachoric/polychoric matrix is not positive definite, then apply a simple smoothing algorithm using cor.smooth}
    \item{\code{global}}{When finding pairwise correlations, should we use the global values of the tau parameter (which is somewhat faster), or the local values (global=FALSE)?  The local option is equivalent to the polycor solution, or to doing one correlation at a time. global=TRUE borrows information for one item pair from the other pairs using those item's frequencies.   This will make a difference in the presence of lots of missing data. With very small sample sizes with global=FALSE and correct=TRUE, the function will fail (for as yet underdetermined reasons. }
    \item{\code{weight}}{A vector of length of the number of observations that specifies the weights to apply to each case.  The NULL case is equivalent of weights of 1 for all cases.  }
    \item{\code{progress}}{Show the progress bar (if  not doing multicores)}
    \item{\code{ML}}{ ML=FALSE  do a quick two step procedure, ML=TRUE, do longer maximum likelihood --- very slow! Deprecated}
    \item{\code{delete}}{Cases with no variance are deleted with a warning before proceeding.}
    \item{\code{max.cat}}{The maximum number of categories to bother with for polychoric.  }
  }}
}
\value{
An object of class \code{data.frame} and \code{sia_parallel}. Can be
  plotted using \code{plot()}.
}
\description{
Computes the eigenvalues of the sample correlation matrix and the eigenvalues
obtained from a random correlation matrix for which no factors/components are
assumed. By default, the function utilizes a modified Horn's (1965) method,
which -- instead of mean -- uses 95th percentile of each item eigenvalues
sampling distribution as a threshold to find the optimal number of
factors/components.
}
\details{
Horn proposed a solution to the problem of optimal factor number
identification using an approach based on a Monte Carlo simulation.

First, several (20 by default) zero-factor \code{p}-variate normal
distributions (where \code{p} is the number of columns) are obtained, and
\code{p} × \code{p} correlation matrices are computed for them. Eigenvalues
of each matrix is then calculated in order to get an eigenvalues sampling
distribution for each simulated variable.

Traditionally, Horn obtains an average of each sampling distribution and
these averages are used as a threshold which is compared with eigenvalues of
the original, real data. However, \emph{usage of the mean was later disputed}
by Buja & Eyuboglu (1992), and 95th percentile of eigenvalues sampling
distribution was suggested as a more accurate threshold. This, more recent
method is used by default in the function.
}
\examples{
data("TestAnxietyCor", package = "ShinyItemAnalysis")
fa_parallel(TestAnxietyCor, n_obs = 335, method = "pca")

\dontrun{
data("bfi", package = "psych")
items <- bfi[, 1:25]

fa_parallel(items)
fa_parallel(items, threshold = "mean") # traditional Horn's method
}

}
\references{
Horn, J. L. (1965). A rationale and test for the number of factors in factor
analysis. Psychometrika, 30, 179--185. \doi{10.1007/BF02289447}

Buja, A., & Eyuboglu, N. (1992). Remarks on parallel analysis. Multivariate
Behavioral Research, 27, 509--540. \doi{10.1207/s15327906mbr2704_2}
}
\author{
Jan Netik \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{netik@cs.cas.cz}

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz}
}
