% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataMedical.R
\docType{data}
\name{dataMedical}
\alias{dataMedical}
\title{Dichotomous dataset of admission test to medical school}
\format{
A \code{dataMedical} is a \code{data.frame} consisting of 2,392 observations on
the following 102 variables.
\describe{
\item{X}{The first 100 columns represent dichotomously scored items of the
test. }
\item{gender}{Variable describing gender; values \code{"0"} and \code{"1"} refer to
males and females. }
\item{StudySuccess}{Criterion variable; value \code{"1"} means that student
studies standardly, \code{"0"} otherwise (e.g., leaving or interrupting studies). }
}
}
\source{
Stuka, C., Vejrazka, M., Martinkova, P., Komenda, M., & Stepanek, L. (2016).
The use of test and item analysis for improvement of tests. Workshop held at
conference MEFANET, 2016, Brno, Czech Republic.
}
\usage{
data(dataMedical)
}
\description{
The \code{dataMedical} dataset consists of the responses of 2,392
subjects (750 males, 1,633 females and 9 subjects without gender
specification) to admission test to a medical school. It contains 100
items. A correct answer is coded as \code{"1"} and incorrect answer as \code{"0"}.
Missing answers were evaluated as incorrect, i.e. \code{"0"}.
}
\references{
Martinkova, P., & Drabinova, A. (2018). ShinyItemAnalysis for
teaching psychometrics and to enforce routine analysis of educational tests.
The R Journal, 10(2), 503--515, \doi{10.32614/RJ-2018-074}
}
\seealso{
\code{\link{dataMedicaltest}}, \code{\link{dataMedicalkey}},
\code{\link{dataMedicalgraded}}
}
\keyword{datasets}
