% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCumulative.R
\name{plotCumulative}
\alias{plotCumulative}
\title{Function for plotting cumulative and category probabilities of cumulative logistic regression model}
\usage{
plotCumulative(x, type = "cumulative", matching.name = "matching")
}
\arguments{
\item{x}{object of class \code{vglm}}

\item{type}{character: type of plot to be displayed. Options are \code{"cumulative"} (default) for cumulative probabilities
and \code{"category"} for category probabilities.}

\item{matching.name}{character: name of matching criterion used for estimation in \code{x}.}
}
\description{
Function for plotting cumulative and category probabilities function estimated by \code{vglm()} from \code{VGAM} package
}
\examples{
# loading packages
library(VGAM)

# loading data
data <- dataMedicalgraded[, 1:100]

# total score calculation
score <- apply(data, 1, sum)
data[, 1] <- ordered(factor(data[, 1], levels = 0:max(data[, 1])))

# cummulative logistic model for item 1
fit <- vglm(data[, 1] ~ score, family = cumulative(reverse = TRUE, parallel = TRUE))
# coefficients for item 1
coefs <- coef(fit)

plotCumulative(fit, type = "cumulative", matching.name = "Total score")
plotCumulative(fit, type = "category", matching.name = "Total score")
}
\seealso{
\code{\link[VGAM]{vglm}}
}
\author{
Tomas Jurica \cr

Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
