library(SheetReader)
data <- read_xlsx(system.file("extdata", "multi-test.xlsx", package = "SheetReader"))
stopifnot(colnames(data) == c("Text", "Integer", "Real", "Date", "DateTime", "Boolean", "Formula", "Error", "Blank"))
stopifnot(data[1, "Text"] == "Blabla")
stopifnot(data[1, "Integer"] == 29384723)
stopifnot(data[1, "Real"] == -234.7239)
stopifnot(data[1, "Date"] == as.POSIXct("2021-01-01", "UTC"))
stopifnot(data[1, "DateTime"] == as.POSIXct("2020-04-01 13:37", "UTC"))
stopifnot(data[1, "Boolean"] == TRUE)
stopifnot(data[1, "Formula"] == 14)
stopifnot(is.na(data[1, "Error"]))
stopifnot(is.na(data[1, "Blank"]))
