% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/seurat.R, R/assay.R
\name{AssayData}
\alias{AssayData}
\alias{GetAssayData}
\alias{SetAssayData}
\alias{GetAssayData.Seurat}
\alias{SetAssayData.Seurat}
\alias{GetAssayData.Assay}
\alias{SetAssayData.Assay}
\title{Get and Set Assay Data}
\usage{
GetAssayData(object, slot, ...)

SetAssayData(object, slot, new.data, ...)

\method{GetAssayData}{Seurat}(object, slot = "data", assay = NULL, ...)

\method{SetAssayData}{Seurat}(object, slot = "data", new.data, assay = NULL, ...)

\method{GetAssayData}{Assay}(object, slot = c("data", "scale.data", "counts"), ...)

\method{SetAssayData}{Assay}(object, slot = c("data", "scale.data", "counts"), new.data, ...)
}
\arguments{
\item{object}{An object}

\item{slot}{Specific assay data to get or set}

\item{...}{Arguments passed to other methods}

\item{new.data}{New assay data to add}

\item{assay}{Specific assay to get data from or set data for; defaults to
the \link[SeuratObject:DefaultAssay]{default assay}}
}
\value{
\code{GetAssayData}: returns the specified assay data

\code{SetAssayData}: \code{object} with the assay data set
}
\description{
General accessor and setter functions for \code{\link{Assay}} objects.
\code{GetAssayData} can be used to pull information from any of the
expression matrices (eg. \dQuote{counts}, \dQuote{data}, or
\dQuote{scale.data}). \code{SetAssayData} can be used to replace one of these
expression matrices
}
\examples{
# Get assay data from the default assay in a Seurat object
GetAssayData(object = pbmc_small, slot = "data")[1:5,1:5]

# Set an Assay slot through the Seurat object
count.data <- GetAssayData(object = pbmc_small[["RNA"]], slot = "counts")
count.data <- as.matrix(x = count.data + 1)
new.seurat.object <- SetAssayData(
    object = pbmc_small,
    slot = "counts",
    new.data = count.data,
    assay = "RNA"
)

# Get the data directly from an Assay object
GetAssayData(pbmc_small[["RNA"]], slot = "data")[1:5,1:5]

# Set an Assay slot directly
count.data <- GetAssayData(pbmc_small[["RNA"]], slot = "counts")
count.data <- as.matrix(x = count.data + 1)
new.assay <- SetAssayData(pbmc_small[["RNA"]], slot = "counts", new.data = count.data)

}
\concept{data-access}
