% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{ProjectDimReduc}
\alias{ProjectDimReduc}
\title{Project query data to reference dimensional reduction}
\usage{
ProjectDimReduc(
  query,
  reference,
  mode = c("pcaproject", "lsiproject"),
  reference.reduction,
  combine = FALSE,
  query.assay = NULL,
  reference.assay = NULL,
  features = NULL,
  do.scale = TRUE,
  reduction.name = NULL,
  reduction.key = NULL,
  verbose = TRUE
)
}
\arguments{
\item{query}{Query object}

\item{reference}{Reference object}

\item{mode}{Projection mode name for projection
 \itemize{
\item{pcaproject: PCA projection}
\item{lsiproject: LSI projection}
}}

\item{reference.reduction}{Name of dimensional reduction in the reference object}

\item{combine}{Determine if query and reference objects are combined}

\item{query.assay}{Assay used for query object}

\item{reference.assay}{Assay used for reference object}

\item{features}{Features used for projection}

\item{do.scale}{Determine if scale expression matrix in the pcaproject mode}

\item{reduction.name}{dimensional reduction name, reference.reduction is used by default}

\item{reduction.key}{dimensional reduction key, the key in reference.reduction
is used by default}

\item{verbose}{Print progress and message}
}
\value{
Returns a query-only or query-reference combined seurat object
}
\description{
Project query data to reference dimensional reduction
}
