% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\docType{class}
\name{DimReduc-class}
\alias{DimReduc-class}
\alias{DimReduc}
\title{The Dimmensional Reduction Class}
\description{
The DimReduc object stores a dimensionality reduction taken out in Seurat; each DimReduc
consists of a cell embeddings matrix, a feature loadings matrix, and a projected feature
loadings matrix.
}
\section{Slots}{

\describe{
\item{\code{cell.embeddings}}{Cell embeddings matrix (required)}

\item{\code{feature.loadings}}{Feature loadings matrix (optional)}

\item{\code{feature.loadings.projected}}{Projected feature loadings matrix (optional)}

\item{\code{assay.used}}{Name of assay used to generate \code{DimReduc} object}

\item{\code{global}}{Is this \code{DimReduc} global/persistent? If so, it will not be
removed when removing its associated assay}

\item{\code{stdev}}{A vector of standard deviations}

\item{\code{key}}{Key for the \code{DimReduc}, must be alphanumerics followed by an underscore}

\item{\code{jackstraw}}{A \code{\link{JackStrawData-class}} object associated with
this \code{DimReduc}}

\item{\code{misc}}{Utility slot for storing additional data associated with the
\code{DimReduc} (e.g. the total variance of the PCA)}
}}

