% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{OldWhichCells}
\alias{OldWhichCells}
\alias{OldWhichCells.Assay}
\alias{OldWhichCells.Seurat}
\title{Identify cells matching certain criteria}
\usage{
OldWhichCells(object, ...)

\method{OldWhichCells}{Assay}(
  object,
  cells,
  subset.name = NULL,
  low.threshold = -Inf,
  high.threshold = Inf,
  accept.value = NULL,
  ...
)

\method{OldWhichCells}{Seurat}(
  object,
  cells = NULL,
  subset.name = NULL,
  low.threshold = -Inf,
  high.threshold = Inf,
  accept.value = NULL,
  ident.keep = NULL,
  ident.remove = NULL,
  max.cells.per.ident = Inf,
  random.seed = 1,
  assay = NULL,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods and \code{FetchData}}

\item{cells}{Subset of cell names}

\item{subset.name}{Parameter to subset on. Eg, the name of a gene, PC_1, a
column name in object@meta.data, etc. Any argument that can be retreived
using FetchData}

\item{low.threshold}{Low cutoff for the parameter (default is -Inf)}

\item{high.threshold}{High cutoff for the parameter (default is Inf)}

\item{accept.value}{Returns all cells with the subset name equal to this value}

\item{ident.keep}{Create a cell subset based on the provided identity classes}

\item{ident.remove}{Subtract out cells from these identity classes (used for
filtration)}

\item{max.cells.per.ident}{Can be used to downsample the data to a certain
max per cell ident. Default is INF.}

\item{random.seed}{Random seed for downsampling}

\item{assay}{Which assay to filter on}
}
\value{
A vector of cell names
}
\description{
Returns a list of cells that match a particular set of criteria such as
identity class, high/low values for particular PCs, ect..
}
\examples{
\dontrun{
OldWhichCells(object = pbmc_small, ident.keep = 2)
}

}
\seealso{
\code{\link{FetchData}}
}
