% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{NegBinomRegDETest}
\alias{NegBinomRegDETest}
\title{Negative binomial test for UMI-count based data (regularized version)}
\usage{
NegBinomRegDETest(object, cells.1, cells.2, genes.use = NULL,
  latent.vars = NULL, print.bar = TRUE, min.cells = 3)
}
\arguments{
\item{object}{Seurat object}

\item{cells.1}{Group 1 cells}

\item{cells.2}{Group 2 cells}

\item{genes.use}{Genes to use for test}

\item{latent.vars}{Latent variables to test}

\item{print.bar}{Print progress bar}

\item{min.cells}{Minimum number of cells threshold}
}
\value{
Returns a p-value ranked data frame of test results.
}
\description{
Identifies differentially expressed genes between two groups of cells using
a likelihood ratio test of negative binomial generalized linear models where
the overdispersion parameter theta is determined by pooling information
across genes.
}
\examples{
# Note, not recommended for particularly small datasets - expect warnings
NegBinomDETest(
  object = pbmc_small,
  cells.1 = WhichCells(object = pbmc_small, ident = 1),
  cells.2 = WhichCells(object = pbmc_small, ident = 2)
)

}
