% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotprobs.R
\name{plotprobs}
\alias{plotprobs}
\title{Plots results from select}
\usage{
plotprobs(result, traits)
}
\arguments{
\item{result}{A saved object from function select()}

\item{traits}{A 2D matrix of trait values}
}
\value{
3D barplot that illustrates probabilities of species located within a 2D trait space
}
\description{
This function plots results (species probabilities/optimum solutions) from the select() function
}
\examples{
##### 2 traits: Constrain trait X to value 2.5, diversify trait Y
trait.matrix <- as.matrix(cbind(traitX=c(rep(1,3),rep(2,3),rep(3,3)),
                traitY=c(rep(c(1,2,3),3))))
rownames(trait.matrix)=c(letters[1:9])
result3 = select(t2c=as.matrix(trait.matrix[,1]),constraints=c(2.5),
          t2d=as.matrix(trait.matrix[,2]),capd=TRUE,obj="FDandE")
plotprobs(result3,trait.matrix)
}

