% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saferank.R
\name{new_SafeRankExpt}
\alias{new_SafeRankExpt}
\title{Constructor for the results of a SafeRank experiment}
\usage{
new_SafeRankExpt(
  rankNames = list(),
  marginNames = list(),
  countMethod = character(0),
  rankMethod = character(0),
  datasetName = character(0),
  experimentalMethod = character(0),
  countArgs = list(),
  nseats = integer(0),
  otherFactors = list(),
  unitFactors = list()
)
}
\arguments{
\item{rankNames}{colnames for per-candidate ranks}

\item{marginNames}{colnames for per-candidate margins}

\item{countMethod}{secondary factor: counting method e.g. "stv"}

\item{rankMethod}{secondary factor: ranking method e.g. "elected"}

\item{datasetName}{secondary factor: name of the dataset of ballots}

\item{experimentalMethod}{secondary factor: name of the method which
simulated these elections e.g. "testFraction"}

\item{countArgs}{secondary factor: args passed to countMethod}

\item{nseats}{secondary factor: number of seats to be filled}

\item{otherFactors}{other secondary factors, e.g. parameters to
experimentalMethod}

\item{unitFactors}{per-unit factors derived from PRNG of the experimental
harness, e.g describing the ballots randomly deleted during testDeletions}
}
\value{
object of class SafeRankExpt
}
\description{
Constructor for the results of a SafeRank experiment
}
