% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_percentile_plot.R
\name{threshold_percentile_plot}
\alias{threshold_percentile_plot}
\alias{threshold_percentile_plot.swmpr}
\title{Threshold Percentile Plot}
\usage{
threshold_percentile_plot(swmpr_in, ...)

\method{threshold_percentile_plot}{swmpr}(
  swmpr_in,
  param = NULL,
  hist_rng = NULL,
  target_yr = NULL,
  percentiles = c(0.05, 0.95),
  free_y = FALSE,
  by_month = FALSE,
  log_trans = FALSE,
  converted = FALSE,
  plot_title = FALSE,
  ...
)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods (not used for this function).}

\item{param}{chr, variable to plot}

\item{hist_rng}{num, years to include in the plot. This variable can either be one year (e.g., \code{hist_rng = 2012}), or two years (e.g. \code{hist_rng = c(2012, 2016)}) , If range is not specified then the entire data set will be used.}

\item{target_yr}{num, year of interest for plotting. If not specified, the entire data set will be plotted.}

\item{percentiles}{num, percentiles to calculate (maximum: 2). Defaults to 5th and 95th percentiles.}

\item{free_y}{logical, should the y-axis be free? Defaults to \code{FALSE}. If \code{FALSE}, defaults to zero, unless negative values are present. If \code{TRUE}, y-axis limits are selected by \code{ggplot}}

\item{by_month}{logical. should percentiles be calculated on a monthly basis? Defaults to \code{FALSE}}

\item{log_trans}{logical, should y-axis be log? Defaults to \code{FALSE}}

\item{converted}{logical, were the units converted from the original units used by CDMO? Defaults to \code{FALSE}. See \code{y_labeler} for details.}

\item{plot_title}{logical, should the station name be included as the plot title? Defaults to \code{FALSE}}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object
}
\description{
Observed data compared against user-defined percentiles
}
\details{
This function provides an alternative to \code{\link{threshold_criteria_plot}}. For parameters that may not have numeric threshold criteria, a percentile threshold can be used instead. For a one-tailed analysis, the 90-th percentile is recommended. For a two-tailed analysis, the 5-th and 95-th percentiles are recommended.

Using \code{by_month}, the user can specify whether the percentiles should be calculated on a monthly basis or by using the entire data set.

Recommended thresholds for chlorophyll-a, dissolved inorganic nitrogen, dissolved inorganic phosphorus, and dissolved oxygen can be found in the National Coastal Condition Assessment 2010 (USEPA 2016)
}
\examples{
dat_wq <- qaqc(elksmwq, qaqc_keep = c(0, 3, 5))
dat_wq <- subset(dat_wq, subset = '2007-01-01 0:00', operator = '>=')

x <-
  threshold_percentile_plot(dat_wq, param = 'do_mgl'
                           , hist_rng = c(2007, 2014), by_month = FALSE)

\donttest{
y <-
  threshold_percentile_plot(dat_wq, param = 'do_mgl', percentiles = c(0.95)
                           , hist_rng = c(2007, 2014), target_yr = 2014
                           , by_month = FALSE)

x2 <-
  threshold_percentile_plot(dat_wq, param = 'do_mgl'
                           , hist_rng = c(2007, 2014), by_month = TRUE)

y2 <-
  threshold_percentile_plot(dat_wq, param = 'do_mgl'
                           , hist_rng = c(2007, 2014), by_month = TRUE
                           , target_yr = 2014)


dat_nut <- qaqc(elknmnut, qaqc_keep = c(0, 3, 5))
dat_nut <- subset(dat_nut, subset = '2007-01-01 0:00', operator = '>=')
dat_nut <- rem_reps(dat_nut)

x3 <-
  threshold_percentile_plot(dat_nut, param = 'chla_n'
                           , hist_rng = c(2007, 2014), by_month = FALSE)

y3 <-
  threshold_percentile_plot(dat_nut, param = 'chla_n'
                           , hist_rng = c(2007, 2014), by_month = FALSE
                           , target_yr = 2016)
}

}
\references{
United States Environmental Protection Agency (USEPA). 2015. "National Coastal Condition Assessment 2010". EPA 841-R-15-006.
https://cfpub.epa.gov/si/si_public_record_Report.cfm?Lab=OWOW&dirEntryId=327030
}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
\author{
Julie Padilla
}
\concept{analyze}
