% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SUMO.R
\docType{package}
\name{SUMO}
\alias{SUMO-package}
\alias{SUMO}
\title{SUMO: A Package for Simulating Multi-Omics Data}
\value{
A list containing synthetic multi-omics datasets, which may include several omics layers such as gene expression, proteomics, methylation, etc. Each layer is represented as a matrix or data frame where rows correspond to samples and columns correspond to features.
}
\description{
SUMO provides tools for simulating complex multi-omics data, allowing researchers to generate datasets that reflect the biological intricacies found in real-world data. This package aims to fill a gap in current omics research by providing users with flexible and customizable tools for generating synthetic data that can be used for method development, benchmarking of Multi-Omics methods.
}
\details{
Key features of SUMO include:
\itemize{
\item \strong{Simulating Multi-Omics Data}: Generate multi-layered datasets with customizable structures.
\item \strong{Flexible Data Generation}: Control over various simulation parameters such as the sample, noise levels, and signal positions.
\item \strong{Visualization Tools}: Functions to visualize simulated data, including scatterplots, histogram, heatmaps and 3D visualization.
}

Key functions include:
\itemize{
\item \code{OmixCraftHD()}: Generates synthetic multi-omics datasets based on user-defined parameters.
\item \code{plot_simData}: Visualizes the structure of the generated data
\item \code{plot_factor}: Visualizes the raw factor scores, for visual identification of signal noise
\item \code{plot_weights}: Visualizes the raw features loadings, for visual identification of signal noise
}
}
\author{
\strong{Maintainer}: Bernard Isekah Osang'ir \email{Bernard.Osangir@sckcen.be} (\href{https://orcid.org/0000-0002-5557-3602}{ORCID})

Authors:
\itemize{
  \item Bernard Isekah Osang'ir \email{bernard.osangir@uhasselt.be}
}

}
\keyword{internal}
