% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitspace.R
\name{smoothSurvey}
\alias{smoothSurvey}
\alias{fitGeneric}
\title{Fit space-time smoothing models for a generic outcome from complex surveys.}
\usage{
smoothSurvey(data, geo = NULL, Amat, X = NULL,
  responseType = c("binary", "gaussian")[1], responseVar,
  strataVar = "strata", weightVar = "weights", regionVar = "region",
  clusterVar = "~v001+v002", pc.u = 1, pc.alpha = 0.01,
  pc.u.phi = 0.5, pc.alpha.phi = 2/3, CI = 0.95, formula = NULL,
  timeVar = NULL, time.model = c("rw1", "rw2")[1], type.st = 1,
  direct.est = NULL, direct.est.var = NULL, ...)

fitGeneric(data, geo = NULL, Amat, X = NULL,
  responseType = c("binary", "gaussian")[1], responseVar,
  strataVar = "strata", weightVar = "weights", regionVar = "region",
  clusterVar = "~v001+v002", pc.u = 1, pc.alpha = 0.01,
  pc.u.phi = 0.5, pc.alpha.phi = 2/3, CI = 0.95, formula = NULL,
  timeVar = NULL, time.model = c("rw1", "rw2")[1], type.st = 1,
  direct.est = NULL, direct.est.var = NULL, ...)
}
\arguments{
\item{data}{data frame with region and strata information.}

\item{geo}{Deprecated argument from early versions.}

\item{Amat}{Adjacency matrix for the regions.}

\item{X}{Covariate matrix with the first column being the region names. Currently only supporting static region-level covariates.}

\item{responseType}{Type of the response variable, currently supports 'binary' (default with logit link function) or 'gaussian'.}

\item{responseVar}{the response variable}

\item{strataVar}{the strata variable}

\item{weightVar}{the weights variable}

\item{regionVar}{Variable name for region, typically 'v024', for older surveys might be 'v101'}

\item{clusterVar}{Variable name for cluster, typically '~v001 + v002'}

\item{pc.u}{hyperparameter U for the PC prior on precisions.}

\item{pc.alpha}{hyperparameter alpha for the PC prior on precisions.}

\item{pc.u.phi}{hyperparameter U for the PC prior on the mixture probability phi in BYM2 model.}

\item{pc.alpha.phi}{hyperparameter alpha for the PC prior on the mixture probability phi in BYM2 model.}

\item{CI}{the desired posterior credible interval to calculate}

\item{formula}{a string of user-specified random effects model to be used in the INLA call}

\item{timeVar}{The variable indicating time period. If set to NULL then the temporal model and space-time interaction model are ignored.}

\item{time.model}{the model for temporal trends and interactions. It can be either "rw1" or "rw2".}

\item{type.st}{can take values 0 (no interaction), or 1 to 4, corresponding to the type I to IV space-time interaction.}

\item{direct.est}{data frame of direct estimates, with column names of response and region specified by \code{responseVar}, \code{regionVar}, and \code{timeVar}.  When \code{direct.est} is specified, it overwrites the \code{data} input.}

\item{direct.est.var}{the column name corresponding to the variance of direct estimates}

\item{...}{additional arguments passed to \code{svydesign} function.}
}
\value{
\item{HT}{Direct estimates}
\item{smooth}{Smoothed direct estimates}
\item{fit}{a fitted INLA object}
\item{CI}{input argument}
\item{Amat}{input argument}
\item{responseType}{input argument}
\item{formula}{INLA formula}
}
\description{
This function calculates the direct estimates by region and fit a simple spatial smoothing model to the direct estimates adjusting for survey design.
Normal or binary variables are currently supported. For binary variables, the logit transformation is performed on the direct estimates of probabilities, and a Gaussian additive model is fitted on the logit scale using INLA.
}
\details{
The function \code{smoothSurvey} replaces the previous function name \code{fitGeneric} (before version 1.0.0).
}
\examples{
\dontrun{
data(DemoData2)
data(DemoMap2)
fit0 <- smoothSurvey(data=DemoData2,  
Amat=DemoMap2$Amat, responseType="binary", 
responseVar="tobacco.use", strataVar="strata", 
weightVar="weights", regionVar="region", 
clusterVar = "~clustid+id", CI = 0.95)

# Example with region-level covariates
 Xmat <- aggregate(age~region, data = DemoData2, FUN = mean)
 fit1 <- smoothSurvey(data=DemoData2,  
  Amat=DemoMap2$Amat, responseType="binary", 
  X = Xmat,
  responseVar="tobacco.use", strataVar="strata", 
  weightVar="weights", regionVar="region", 
  clusterVar = "~clustid+id", CI = 0.95)

# Example with using only direct estimates as input instead of the full data
direct <- fit$HT[, c("region", "HT.est", "HT.var")]
fit2 <- smoothSurvey(data=NULL, direct.est = direct, 
                    Amat=DemoMap2$Amat, regionVar="region",
                    responseVar="HT.est", direct.est.var = "HT.var", 
                    responseType = "binary")
# Check it is the same as fit0
plot(fit2$smooth$mean, fit0$smooth$mean)

# Example with using only direct estimates as input, 
#   and after transformation into a Gaussian smoothing model
# Notice: the output are on the same scale as the input 
#   and in this case, the logit estimates.    
direct.logit <- fit$HT[, c("region", "HT.logit.est", "HT.logit.var")]
fit3 <- smoothSurvey(data=NULL, direct.est = direct.logit, 
               Amat=DemoMap2$Amat, regionVar="region",
               responseVar="HT.logit.est", direct.est.var = "HT.logit.var",
               responseType = "gaussian")
# Check it is the same as fit0
plot(fit3$smooth$mean, fit0$smooth$logit.mean)

}
}
\seealso{
\code{\link{getDirectList}}, \code{\link{smoothDirect}}
}
\author{
Zehang Richard Li
}
