% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_projINLA.R
\name{plot.projINLA}
\alias{plot.projINLA}
\title{Plot projection output.}
\usage{
\method{plot}{projINLA}(x, years_label = c("85-89", "90-94", "95-99", "00-04",
  "05-09", "10-14", "15-19"), years_med = c(1987, 1992, 1997, 2002, 2007,
  2012, 2017), is.yearly = TRUE, is.subnational = TRUE, proj_year = 2015,
  ...)
}
\arguments{
\item{x}{output from \code{\link{projINLA}}}

\item{years_label}{labels for the periods}

\item{years_med}{labels for the middle years in each period}

\item{is.yearly}{logical indicator of whether the data contains yearly estimates}

\item{is.subnational}{logical indicator of whether the data contains subnational estimates}

\item{proj_year}{The first year where projections are made, i.e., where no data are available.}

\item{...}{optional arguments, see details}
}
\description{
Plot projection output.
}
\details{
Note that arguments after \code{...} must match exactly.
\itemize{
 \item{\code{years_label}}{string of year labels, defaults to \code{c("85-89", "90-94", "95-99", "00-04", "05-09", "10-14", "15-19")}}
 \item{\code{proj_year}}{projection year as numeric, defaults to \code{2015}}
 \item{\code{years_med}}{ median of year intervals, defaults to \code{c(1987, 1992, 1997, 2002, 2007, 2012, 2017)}}
 \item{\code{is.yearly}}{indicator for yearly model, defaults to \code{TRUE}}
 \item{\code{is.subnational}}{indicator for subnational model, defaults to \code{TRUE}}
}
}
\examples{
\dontrun{
data(DemoData)
deta(DemoMap)
years <- levels(DemoData[[1]]$time)

# obtain direct estimates
data <- countrySummary_mult(births = DemoData, 
years = years, idVar = "id", 
regionVar = "region", timeVar = "time", 
clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", 
geo.recode = NULL)

# obtain maps
geo <- DemoMap$geo
mat <- DemoMap$Amat

# Simulate hyper priors
priors <- simhyper(R = 2, nsamp = 1e+05, nsamp.check = 5000, Amat = mat, only.iid = TRUE)

# combine data from multiple surveys
data <- aggregateSurvey(data)

# Model fitting with INLA
years.all <- c(years, "15-19")
fit <- fitINLA(data = data, geo = geo, Amat = mat, 
year_names = years.all, year_range = c(1985, 2019), 
priors = priors, rw = 2, is.yearly=TRUE, 
m = 5, type.st = 4)
# Projection
out <- projINLA(fit, Amat = mat, is.yearly = TRUE)
plot(out, is.yearly=TRUE, is.subnational=TRUE) + ggplot2::ggtitle("Subnational yearly model")

}
}
