% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_in_one_workflow_fun.R
\name{workflow.control}
\alias{workflow.control}
\title{Workflow default options}
\usage{
workflow.control(numberOfMutations = 1, numberOfThreads = 4,
  createdThresholdSignal = 0.05, thresholdHomozygote = 0.4,
  internalTrace = FALSE, simpleReturn = TRUE, identifyNoise = FALSE,
  identifyStutter = FALSE, flankingRegions = NULL, useSTRaitRazor = FALSE,
  trimRegions = TRUE, restrictType = NULL, trace = TRUE,
  variantDatabase = NULL, reduceSize = FALSE)
}
\arguments{
\item{numberOfMutations}{The maximum number of mutations (base-calling errors) allowed during flanking region identification.}

\item{numberOfThreads}{The number of threads used by either the \link{mclapply}-function (stuck at '2' on windows) or STRaitRazor.}

\item{createdThresholdSignal}{Noise threshold.}

\item{thresholdHomozygote}{Homozygote threshold for genotype identiication.}

\item{internalTrace}{Show trace.}

\item{simpleReturn}{TRUE/FALSE: Should the regions be aggregated without including flanking regions?}

\item{identifyNoise}{TRUE/FALSE: Should noise be identified.}

\item{identifyStutter}{TRUE/FALSE: Should stutters be identified.}

\item{flankingRegions}{The flanking regions used to identify the STR regions. If 'NULL' a default set is loaded and used.}

\item{useSTRaitRazor}{TRUE/FALSE: Should the STRaitRazor command line tool (only linux is implemented) be used for flanking region identification.}

\item{trimRegions}{TRUE/FALSE: Should the identified regions be further trimmed.}

\item{restrictType}{A character vector specifying the marker 'Types' to be identified.}

\item{trace}{TRUE/FALSE: Should a trace be shown?}

\item{variantDatabase}{A \link{tibble} of 'trusted' STR regions.}

\item{reduceSize}{TRUE/FALSE: Should the size of the data-set be reduced using the quality and the variant database?}
}
\value{
List of default of options.
}
\description{
Control object for workflow function returning a list of default parameter options.
}
