% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReceptorAbundanceEstimation.R
\name{receptorAbundanceEstimation}
\alias{receptorAbundanceEstimation}
\title{Receptor abundance estimation for single cell RNA-sequencing (scRNA-seq) data using gene set scoring and thresholding.}
\usage{
receptorAbundanceEstimation(
  target.rnaseq,
  receptor.geneset.matrix,
  num.genes = 10,
  rank.range.end = 100,
  min.consec.diff = 0.01,
  rep.consec.diff = 2,
  manual.rank = NULL,
  seed.rsvd = 1,
  max.num.clusters = 4,
  seed.ckmeans = 2
)
}
\arguments{
\item{target.rnaseq}{\eqn{m x n} scRNA-seq counts matrix for \eqn{m} cells and \eqn{n} genes.}

\item{receptor.geneset.matrix}{\eqn{n x h} Gene sets weights membership matrix.}

\item{num.genes}{Number of top most weighted genes for subsequent gene set scoring and thresholding.}

\item{rank.range.end}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}

\item{min.consec.diff}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}

\item{rep.consec.diff}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}

\item{manual.rank}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}

\item{seed.rsvd}{See documentation for the \code{randomizedRRR} function from the \code{SPECK} package.}

\item{max.num.clusters}{See documentation for the \code{ckmeansThreshold} function from the \code{SPECK} package.}

\item{seed.ckmeans}{See documentation for the \code{ckmeansThreshold} function from the \code{SPECK} package.}
}
\value{
\itemize{
  \item \code{receptor.abundance.estimates} - A \eqn{m x h} matrix consisting of abundance estimates for \eqn{m} cells in \eqn{h} receptors.
}
}
\description{
Performs receptor abundance estimation for \eqn{m x n} scRNA-seq target data using gene set scoring and thresholding. scRNA-seq target counts are normalized and
reduced rank reconstructed (RRR) using the \code{\link[SPECK:randomizedRRR]{SPECK::randomizedRRR()}} function. Gene set scoring is next performed leveraging expression from
the top most weighted genes based on the gene sets weights membership matrix with the \code{\link[VAM:vam]{VAM::vam()}} function. The resulting cell-specific gene set scores
are then thresholded utilizing the \code{\link[Ckmeans.1d.dp:Ckmeans.1d.dp]{Ckmeans.1d.dp::Ckmeans.1d.dp()}} function. Note that this function only performs normalization
and does not perform any quality control (QC) checks on the inputted target scRNA-seq counts matrix. Any QC needed can be performed on the target matrix before passing it
as an input to the function.
}
\examples{
data("train.malt.rna.mat")
data("train.malt.adt.mat")
receptor.geneset.matrix.out <- receptorGeneSetConstruction(train.rnaseq =
                                         train.malt.rna.mat[1:100,1:80],
                                         train.citeseq =
                                         train.malt.adt.mat[1:100,1:2],
                                         rank.range.end = 70,
                                         min.consec.diff = 0.01,
                                         rep.consec.diff = 2,
                                         manual.rank = NULL,
                                         seed.rsvd = 1)
dim(receptor.geneset.matrix.out)
head(receptor.geneset.matrix.out)
data("target.malt.rna.mat")
receptor.abundance.estimates.out <- receptorAbundanceEstimation(target.rnaseq =
                                    target.malt.rna.mat[1:200,1:80],
                                    receptor.geneset.matrix =
                                    receptor.geneset.matrix.out,
                                    num.genes = 10, rank.range.end = 70,
                                    min.consec.diff = 0.01,
                                    rep.consec.diff = 2,
                                    manual.rank = NULL, seed.rsvd = 1,
                                    max.num.clusters = 4, seed.ckmeans = 2)
dim(receptor.abundance.estimates.out)
head(receptor.abundance.estimates.out)
}
