% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunction.R
\name{CSAMiningProcess}
\alias{CSAMiningProcess}
\title{CSAMiningProcess}
\usage{
CSAMiningProcess(D, DS, w, a, sb, tb, si, ka)
}
\arguments{
\item{D}{Dataset containing numeric values}

\item{DS}{Dataset containing SAX encoded values}

\item{w}{Word Size}

\item{a}{Number of letters to do the encode}

\item{sb}{Spatial block size}

\item{tb}{Temporal block size}

\item{si}{Minimum number of occurrences inside each block}

\item{ka}{Minimum number of spatial-time series with occurrences inside each block}
}
\value{
Return a list of ranked motifs. Each motif contains the information [isaxcode, recmatrix, vectst, rank], as described:

isaxcode: Motif sequences in character format

recmatrix: Matrix giving as information the blocks containing this motif

vectst: Coordinate of the start positions of the motif in the original dataset

rank: L of information used for motif ranking, as [dist, word, qtd, proj]
}
\description{
CSA Datamining Process
}
\note{
To see more informations: \href{../inst/doc/discovery-motifs.html}{CSA Datamining Process}
}
\examples{
#CSA Datamining process
D  <- STMotif::example_dataset
DS <- NormSAX(STMotif::example_dataset,7)
rmotif <- CSAMiningProcess(D,DS,3,7,10,10,3,7)
}
