\name{readratdatafixed}
\alias{readratdatafixed}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Reads the ratings of a group of raters from a specified textfile into a SSrat compliant dataframe
}
\description{
Given the ratings of a group in a specified textfile, readratdatafixed produces a dataframe that can be processed further with SSrat, using function calcgroup.\cr 
}
\usage{
readratdatafixed(filename, pnames = c(0, 0), pschoolid = c(1, 2), pgroupid = c(3, 4), 
                 prespid = c(5, 6), pratings = c(8, 17), rowsEQassessors = T)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{filename}{
the filename of the textfile to be processed
}
  \item{pnames}{
optional: the fixed postion of the names of the raters/assessed. Default: c(0, 0), not available.
}
  \item{pschoolid}{
the fixed position of a number that identifies the school.
}
  \item{pgroupid}{
the fixed position of a number that identifies the group.
}
  \item{prespid}{
the fixed position of a number that identifies the rater.
}
  \item{pratings}{
the fixed position of the ratings, where each rating is a number of the set \{1, 2, 3\}, \{1..5\}, \{1..7\} or \{1..9\}. When there are 10 raters, the positions covers 10 single digit numbers.
}
  \item{rowsEQassessors}{
A boolean that identifies whether the raters (assessors) are in rows or not. Default is TRUE, the assessors are in rows.
}
}
\details{
Example text file "example1.rat.txt" has the following format:\cr
010101 .717211723\cr
010102 7 72121714\cr
010103 76 7231711\cr
010104 771 141756\cr
010105 7672 51171\cr
010106 77172 1123\cr
010107 767216 711\cr
010108 7717211 45\cr
010109 76721711 6\cr
010110 771722112 \cr

schoolid has position c(1,2), groupid has position c(3,4), respid has position c(5,6), and rating has position c(8,17)

The ratings form often a square (i.e., number of raters is equal to the number of assessed), but the number of raters can be larger or smaller than the number of assessed. See example2.rat.txt for number of raters larger than the number of ratees. See example3.rat.txt for number of raters smaller than the number of ratees.\cr
Ratings can be MISSING, identified by a zero or a non-numeric character. In example1.rat.txt the missing value indicator is a space. File klas2.rat.txt provides another example.\cr
Raters can be in columns. Set rowsEQassessors = FALSE. See example4.rat.txt.\cr
Multiple groups can be processed by radratdatafixed in a single run. It is recommended that the groups are divided by an empty line. The positions of the fields need to be the same for each group. File example6.rat.txt. example7.rat.txt and example8.rat.txt provide examples.
A string that identifies each respondent can be entered optionally. File example1a.rat.txt and klas2.rat.txt provide examples.
}
\value{
The output is a dataframe that can be processed further by SSrat.\cr 
File example1.rat.txt produces a dataframme with the following columns:\cr
schoolid groupid respid r01 r02 r03 r04 r05 r06 r07 r08 r09 r10\cr
and NA where missing values are detected.

N.B. Wrong identification of the various field positions easily leads to a dataframe with unexpected missing values (NA's).
}
\note{Rating data can be entered directly into a SSrat compliant dataframe, using Edit. Colums needed are: "schoolid", "groupid", "respid", and for <n> raters "r01", "r02".."r<n>", with a maximum of r99. Optionally, a column named "resplables" can be entered, containing an extra string identifier of the raters/assessed. The raters (assessors) are in rows and assessed in columns.}
\references{
Maassen, G. H. and Landsheer, J. A. (1998). SSRAT: The processing of rating scales for the determination of two-dimensional sociometric status. Behavior Research Methods Instruments & Computers, 30(4), 674-679.

}
\author{
Hans Landsheer
}
\seealso{
\code{\link{calcgroup}}
}
\examples{
#example file names
filenames = c("example1.rat.txt","example2.rat.txt","example3.rat.txt",
              "example4.rat.txt","example5.rat.txt","example6.rat.txt",
              "example7.rat.txt","example1a.rat.txt","klas2.rat.txt")
filenames=paste(path.package("SSrat"),"/extdata/",filenames, sep="") 

# show raw text file
cat( readLines( filenames[1] ) , sep = "\n" )
              
#single group, no names, standard positions
(example1.rat = readratdatafixed(filenames[1]))
(example2.rat = readratdatafixed(filenames[2])) # raters < assessed
(example3.rat = readratdatafixed(filenames[3])) # raters > assessed
(example4.rat = readratdatafixed(filenames[4], rowsEQassessors = FALSE)) # raters in columns
(example5.rat = readratdatafixed(filenames[5]))


#multiple groups
(example6.rat = readratdatafixed(filenames[6]))
(example7.rat = readratdatafixed(paste(filenames[7])))

#single groups, with names: define positions
(example1a.rat = readratdatafixed(filenames[8], 
                           pnames=c(1,10), 
                           pschoolid=c(11,12), pgroupid=c(13,14),
                           prespid=c(15,16), pratings=c(18,27)))
(klas2.rat = readratdatafixed(filenames[9], 
                            pnames=c(10,20), 
                            pschoolid=c(1,2), pgroupid=c(3,4),
                            prespid=c(5,6), pratings=c(21,32)))

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ datasets }
