% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotPlot.R
\name{ggparcoordPrepare}
\alias{ggparcoordPrepare}
\title{Build data frame for ggparcoord (parallel plot)}
\usage{
ggparcoordPrepare(
  x,
  y,
  xlab = NULL,
  ylab = NULL,
  probs = seq(0.25, 0.75, 0.25),
  yrange = NULL
)
}
\arguments{
\item{x}{elements \code{x}, e.g., result from a \code{\link[SPOT]{spot}} run.}

\item{y}{associated function values}

\item{xlab}{character, the value of the independent variable}

\item{ylab}{character, the value of the dependent variable predicted by the corresponding model.}

\item{probs}{quantile probabilities. Default:  \code{seq(0, 1, 0.25)}}

\item{yrange}{y interval}
}
\value{
data frame for \code{\link[GGally]{ggparcoord}}
}
\description{
Build data frame for ggparcoord (parallel plot)
}
\examples{
require(SPOT)
require(GGally)
n <- 4 # param
k <- 50 # samples
x <- designUniformRandom(,rep(0,n), rep(1,n),control=list(size=k))
y <- matrix(0, nrow=k,ncol=1)
y <- funSphere(x)
result <- list(x=x, y=y)
df <- ggparcoordPrepare(x=result$x,
                        y=result$y,
                        xlab=result$control$parNames,
                        probs = c(0.25, 0.5, 0.75))
                        #probs = c(0.1, 0.9))  # c(0.9,0.95) )#seq(0.25, 1, 0.25))
m <- ncol(df)
splineFactor <- max(1, floor(2*m))
ggparcoord(data=df, columns = 1:(m-2), groupColumn = m,
scale = "uniminmax", boxplot = FALSE, alphaLines = 0.2,showPoints = TRUE)
##
\donttest{
require(SPOT)
require(GGally)
result <- spot(x=NULL,
              fun=funSphere,
              lower=rep(-1,3),
              upper= rep(1,3),
 control=list(funEvals=20,
             model=buildKriging,
             modelControl=list(target="y")))

df <- ggparcoordPrepare(x=result$x,
                        y=result$y,
                        xlab=result$control$parNames,
                        probs = c(0.25, 0.5, 0.75))  # c(0.9,0.95) )#seq(0.25, 1, 0.25))
m <- ncol(df)
splineFactor <- max(1, floor(2*m))
ggparcoord(data=df, columns = 1:(m-2), groupColumn = m,
splineFactor = splineFactor, scale = "uniminmax",
boxplot = FALSE, alphaLines = 0.2,showPoints = TRUE, scaleSummary = "median")
}

}
