/*
 * Decompiled with CFR 0.152.
 */
package de.fhkoeln.spot.algorithms;

import de.fhkoeln.spot.objectivefunctions.IObjectiveFunction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public final class SimpleOnePlusOneES {
    static final int PRINT_NONE = 0;
    static final int PRINT_BEST = 1;
    static final int PRINT_IMPROVING = 2;
    static final int PRINT_ALL = 3;

    public static IndividualFitnessPair evolution(RealVector realVector, double d, double d2, int n, IObjectiveFunction iObjectiveFunction, ITerminationCriterion iTerminationCriterion, Random random, boolean bl, int n2, int n3) {
        long l = 0L;
        RealVector realVector2 = realVector;
        double d3 = Double.MAX_VALUE;
        double d4 = d;
        int n4 = realVector.dimension();
        MutationHistory mutationHistory = new MutationHistory(n);
        if (bl) {
            System.out.print("1+1 ES evolution running");
        }
        while (!iTerminationCriterion.isFullfilled(l, d3)) {
            double d5;
            double d6;
            double d7 = d3 = iObjectiveFunction.isFeasible(realVector2.data) ? iObjectiveFunction.valueOf(realVector2.data) : Double.MAX_VALUE;
            if (n2 == 3) {
                System.out.println(realVector2);
            }
            if (n3 == 3) {
                System.out.println(d3);
            }
            RealVector realVector3 = realVector2.plus(RealVector.gaussianRandom(n4, random).timesScalar(d4));
            double d8 = d6 = iObjectiveFunction.isFeasible(realVector3.data) ? iObjectiveFunction.valueOf(realVector3.data) : Double.MAX_VALUE;
            if (d6 < d3) {
                mutationHistory.recordSuccess();
                realVector2 = realVector3;
                d3 = d6;
                if (n2 == 2) {
                    System.out.println(l + " " + realVector2);
                }
                if (n3 == 2) {
                    System.out.println(l + " " + d3);
                }
            } else {
                mutationHistory.recordFailure();
            }
            if ((d5 = mutationHistory.successRate()) > 0.2) {
                d4 *= d2;
            } else if (d5 < 0.2) {
                d4 /= d2;
            }
            if (bl && l % 100L == 0L) {
                System.out.print(".");
            }
            ++l;
        }
        if (n2 == 3) {
            System.out.println(realVector2);
        }
        if (n3 == 3) {
            System.out.println(d3);
        }
        if (bl) {
            System.out.println("DONE.");
        }
        return new IndividualFitnessPair(realVector2, d3);
    }

    static void printUsage(String string) {
        System.out.println("usage: " + string + " seed steps target f n xp0 sigma0 a g px py" + "\n  where" + "\n    seed    random seed ( e.g. 12345 )" + "\n    steps   maximum number of evolution steps ( e.g. 10000 )" + "\n    target  objective function threshold for preliminary evolution end ( e.g. 0.0001 )" + "\n    f       objective function class name ( e.g. de.fhkoeln.spot.objectivefunctions.Ball )" + "\n    n       problem dimension ( e.g. 12 )" + "\n    xp0     starting point" + "\n            ( uniform             = uniformly distributed random vector from [0.0,1.0]^n," + "\n              gaussian            = normally distributed random vector from N(0,1)," + "\n              c(xp0_0,...,xp0_n)  = the vector [xp0_0,...,xp0_n]," + "\n              [xp0_0,...,xp0_n]   = the vector [xp0_0,...,xp0_n]," + "\n              xp0_0,...,xp0_n     = the vector [xp0_0,...,xp0_n] )" + "\n    sigma0  initial step size ( e.g. 1.0 )" + "\n    a       step size muliplier ( e.g. 1.2239 )" + "\n    g       history length ( e.g. 12 = n )" + "\n    px      individual printing mode" + "\n            ( 0 = do not print individuals," + "\n              1 = only print best individual," + "\n              2 = only print improving step numbers and individuals," + "\n              3 = print every individual )" + "\n    py      objective function value printing mode" + "\n            ( 0 = do not print objective function values," + "\n              1 = only print best objective function value," + "\n              2 = only print improving step numbers and objective function values," + "\n              3 = print every objective function value )" + "\n");
    }

    static final RealVector parseRVector(String string) {
        try {
            String[] stringArray = null;
            stringArray = string.toLowerCase().startsWith("c") ? string.toLowerCase().substring(2, string.length() - 1).split(",") : (string.toLowerCase().startsWith("[") ? string.toLowerCase().substring(1, string.length() - 1).split(",") : string.toLowerCase().split(","));
            double[] dArray = new double[stringArray.length];
            int n = 0;
            for (String string2 : stringArray) {
                dArray[n] = Double.parseDouble(string2.trim());
                ++n;
            }
            return new RealVector(dArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("R vector syntax error: " + string);
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            long l = Long.parseLong(stringArray[0]);
            Random random = new Random(l);
            final long l2 = Long.parseLong(stringArray[1]);
            final double d = Double.parseDouble(stringArray[2]);
            String string = stringArray[3];
            Class<?> clazz = Class.forName(string);
            int n = Integer.parseInt(stringArray[4]);
            String string2 = stringArray[5].trim().toLowerCase();
            RealVector realVector = null;
            if (string2.equals("uniform")) {
                realVector = RealVector.random(n, random);
            } else if (string2.equals("gaussian")) {
                realVector = RealVector.gaussianRandom(n, random);
            } else {
                realVector = SimpleOnePlusOneES.parseRVector(string2);
                if (realVector.dimension() != n) {
                    throw new IllegalArgumentException("dimension of xp0 must be equal to n");
                }
            }
            double d2 = Double.parseDouble(stringArray[6]);
            double d3 = Double.parseDouble(stringArray[7]);
            int n2 = Integer.parseInt(stringArray[8]);
            int n3 = Integer.parseInt(stringArray[9]);
            if (n3 < 0 || n3 > 3) {
                throw new IllegalArgumentException("px must be 0, 1, 2, or 3");
            }
            int n4 = Integer.parseInt(stringArray[10]);
            if (n4 < 0 || n4 > 3) {
                throw new IllegalArgumentException("py must be 0, 1, 2, or 3");
            }
            bl = true;
            IndividualFitnessPair individualFitnessPair = SimpleOnePlusOneES.evolution(realVector, d2, d3, n, (IObjectiveFunction)clazz.newInstance(), new ITerminationCriterion(){

                @Override
                public boolean isFullfilled(long l, double d2) {
                    return l >= l2 || d2 <= d;
                }
            }, random, false, n3, n4);
            if (n3 == 1) {
                System.out.println(individualFitnessPair.individual);
            }
            if (n4 == 1) {
                System.out.println(individualFitnessPair.fitness);
            }
            System.exit(0);
        }
        catch (Exception exception) {
            if (!bl) {
                SimpleOnePlusOneES.printUsage("simpleOnePlusOneES");
            }
            System.err.println("Error: " + exception + "\n");
            System.exit(1);
        }
    }

    public static final class RealVector {
        final double[] data;

        RealVector(double[] dArray) {
            this.data = dArray;
        }

        int dimension() {
            return this.data.length;
        }

        RealVector plus(RealVector realVector) {
            double[] dArray = new double[this.dimension()];
            for (int i = 0; i < this.dimension(); ++i) {
                dArray[i] = realVector.data[i] + this.data[i];
            }
            return new RealVector(dArray);
        }

        RealVector timesScalar(double d) {
            double[] dArray = new double[this.dimension()];
            for (int i = 0; i < this.dimension(); ++i) {
                dArray[i] = d * this.data[i];
            }
            return new RealVector(dArray);
        }

        static RealVector random(int n, Random random) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = random.nextDouble();
            }
            return new RealVector(dArray);
        }

        static RealVector gaussianRandom(int n, Random random) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = random.nextGaussian();
            }
            return new RealVector(dArray);
        }

        public String toString() {
            return Arrays.toString(this.data);
        }
    }

    public static final class MutationHistory {
        private final LinkedList<Integer> historyList = new LinkedList();
        private final int g;

        public MutationHistory(int n) {
            this.g = n;
        }

        public void record(boolean bl) {
            this.historyList.addFirst(bl ? 1 : 0);
            if (this.historyList.size() > this.g) {
                this.historyList.removeLast();
            }
        }

        public void recordSuccess() {
            this.record(true);
        }

        public void recordFailure() {
            this.record(false);
        }

        public double successRate() {
            double d = 0.0;
            Iterator iterator = this.historyList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                d += (double)n;
            }
            return d / (double)this.historyList.size();
        }
    }

    public static final class IndividualFitnessPair {
        public final RealVector individual;
        public final double fitness;

        public IndividualFitnessPair(RealVector realVector, double d) {
            this.individual = realVector;
            this.fitness = d;
        }

        public String toString() {
            return "<individual: " + this.individual + "\n fitness: " + this.fitness + ">";
        }
    }

    public static interface ITerminationCriterion {
        public boolean isFullfilled(long var1, double var3);
    }
}

