% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_simulation.R
\name{dat2mat}
\alias{dat2mat}
\title{dat2mat}
\usage{
dat2mat(dat, score, group1, group2, nquant = 20, cats = unique(dat$reason))
}
\arguments{
\item{dat}{data frame with population data, such as output from sim_pop_data. Must include a column \code{reason}}

\item{score}{risk scores corresponding to \code{dat}}

\item{group1}{indices for group 1}

\item{group2}{indices for group 2}

\item{nquant}{number of quantiles of code to use; default 20}

\item{cats}{vector of strings giving names of admission categories; default the unique values in dat$reason. Can include NAs.}
}
\value{
list with two objects \code{matrix1} and \code{matrix2} giving output matrices
}
\description{
Generates matrices for decomposition of admission type which can be used in \code{plot_decomp}
}
\details{
Generates two matrices with the following specifications:
Each matrix corresponds to one group
Columns are named with the admission types to be plotted. Any admission
types including the string 'Died' are counted as deaths
If the matrix has N rows, these are interpreted as corresponding to N
score quantiles
The (i,j)th entry of the matrix is the number of people admitted for
reason i with a score greater than or equal to (j-1)/N and less than (j/N)
who are in that group
}
\examples{
# See vignette
}
