% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colglobal.R
\name{get_colglobal}
\alias{get_colglobal}
\title{Search Catalogue of Life Global checklist}
\usage{
get_colglobal(query, option = "name", response = "terse", start = 0)
}
\arguments{
\item{query}{\code{string} The string to search for.}

\item{option}{\code{character} There is one required parameter, which is either name or id. Give eithera name or an ID. If an ID is given, the name parameter may not be used, and vice versa. option=c("id","name"),the default value is "name". Only exact matches found the name given will be returned, unless a wildcard (*) is appended. Wildcards are allowed only at the end of the string. This offers the option to e.g. search for genus* to retrieve the genus plus all its (infra)species. The name must be at least 3 characters long, not counting the wildcard character. The record ID of the specific record to return (only for scientific names of species or infraspecific taxa).}

\item{response}{\code{character} Type of response returned. Valid values are response=terse and response=full. if the response parameter is omitted, the results are returned in the default terse format. If format=terse then a minimum set of results are returned (this is faster and smaller, enough for name lookup), if format=full then all available information is returned, response=c("full","terse"),the default value is "terse".}

\item{start}{\code{integer} The first record to return. If omitted, the results are returned from the first record (start=0). This is useful if the total number of results is larger than the maximum number of results returned by a single Web service query (currently the maximum number of results returned by a single query is 500 for terse queries and 50 for full queries,the default value is 0.}
}
\value{
object
}
\description{
Get Catalogue of Life Global checklist via species name and id.
}
\details{
Visit the website \url{http://webservice.catalogueoflife.org/col/webservice} for more details.
}
\examples{
\dontrun{
dbentry1 <- get_colglobal(query = "4fdb38d6220462049eab9e3f285144e0", option = "id")
str(dbentry1)
head(dbentry1$results)

dbentry2 <- get_colglobal(query = "Platalea leucorodia", option = "name")
str(dbentry2)
head(dbentry2$results)

find_synonyms("Anguilla anguilla")
}
}
\author{
Liuyong Ding
}
