% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParamBee.R
\name{swarmPUnif}
\alias{swarmPUnif}
\title{Sample the swarm proportion - the proportion of workers that swarm}
\usage{
swarmPUnif(colony, n = 1, min = 0.4, max = 0.6)
}
\arguments{
\item{colony}{\code{\link[SIMplyBee]{Colony-class}}}

\item{n}{integer, number of samples}

\item{min}{numeric, lower limit for \code{swarmPUnif}}

\item{max}{numeric, upper limit for \code{swarmPUnif}}
}
\value{
numeric, swarm proportion
}
\description{
Sample the swarm proportion - the proportion of workers that
  swarm - used when \code{p = NULL} (see \code{\link[SIMplyBee]{SimParamBee}$swarmP}).

  This is just an example. You can provide your own functions that satisfy
  your needs!
}
\details{
\code{swarmPUnif} samples from a uniform distribution between values
  0.4 and 0.6 irrespective of colony strength.

  The \code{nWorkersFull} default value used in this function is geared
  towards a situation where we simulate ~100 workers per colony (down-scaled
  simulation for efficiency). If you simulate more workers, you should change
  the default accordingly.
}
\examples{
swarmPUnif()
swarmPUnif()
p <- swarmPUnif(n = 1000)
hist(p, breaks = seq(from = 0, to = 1, by = 0.01), xlim = c(0, 1))
}
\seealso{
\code{\link[SIMplyBee]{SimParamBee}} field \code{swarmP}
}
