% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QF.R
\name{QF}
\alias{QF}
\title{Inference for quadratic forms of the regression vector in high dimensional linear regression}
\usage{
QF(
  X,
  y,
  G,
  Cov.weight = TRUE,
  A = NULL,
  tau.vec = c(1),
  init.coef = NULL,
  lambda = NULL,
  mu = NULL,
  step = NULL,
  resol = 1.5,
  maxiter = 6,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{X}{Design matrix, of dimension \eqn{n} x \eqn{p}}

\item{y}{Outcome vector, of length \eqn{n}}

\item{G}{The set of indices, \code{G} in the quadratic form}

\item{Cov.weight}{Logical, if set to \code{TRUE} then \code{A } is the \eqn{|G|\times}\eqn{|G|} submatrix of the population covariance matrix corresponding to the index set \code{G}, else need to provide an \code{A} (default = TRUE)}

\item{A}{The matrix A in the quadratic form, of dimension \eqn{|G|\times}\eqn{|G|} (default = \code{NULL})}

\item{tau.vec}{The vector of enlargement factors for asymptotic variance of the bias-corrected estimator to handle super-efficiency (default = \eqn{1})}

\item{init.coef}{Initial estimator for the regression vector (default = \code{NULL})}

\item{lambda}{The tuning parameter used in the construction of \code{init.coef} (default = \code{NULL})}

\item{mu}{The dual tuning parameter used in the construction of the projection direction (default = \code{NULL})}

\item{step}{The step size used to compute \code{mu}; if set to \code{NULL} it is
computed to be the number of steps (< \code{maxiter}) to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = \code{NULL})}

\item{resol}{Resolution or the factor by which \code{mu} is increased/decreased to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = 1.5)}

\item{maxiter}{Maximum number of steps along which \code{mu} is increased/decreased to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = 6)}

\item{alpha}{Level of significance to test the null hypothesis which claims that the quadratic form of the regression vector is equal to 0 (default = 0.05)}

\item{verbose}{Should inetrmediate message(s) be printed (default = \code{TRUE})}
}
\value{
\item{prop.est}{The bias-corrected estimator of the quadratic form of the regression vector}
\item{se}{The standard error of the bias-corrected estimator}
\item{CI}{The matrix of confidence interval for the quadratic form of the regression vector; row corresponds to different values of \code{tau.vec}}
\item{decision}{\code{decision}\eqn{=1} implies the quadratic form of the regression vector is above zero \eqn{\newline}
\code{decision}\eqn{=0} implies the quadratic form of the regression vector is zero \eqn{\newline}
row corresponds to different values of \code{tau.vec}}
\item{proj}{The projection direction, of length \eqn{p}}
\item{plug.in}{The plug-in estimator for the quadratic form of the regression vector restricted to \code{G}}
}
\description{
Computes the bias-corrected estimator of the quadratic form of the regression vector, restricted to the set of indices \code{G} for the high dimensional linear regression and the corresponding standard error.
It also constructs the confidence interval for the quadratic form and test whether it is above zero or not.
}
\examples{
n = 100
p = 200
A1gen <- function(rho,p){
A1=matrix(0,p,p)
for(i in 1:p){
 for(j in 1:p){
   A1[i,j]<-rho^(abs(i-j))
 }
}
A1
}
mu <- rep(0,p)
mu[1:5] <- c(1:5)/5
rho = 0.5
Cov <- (A1gen(rho,p))/2
beta <- rep(0,p)
beta[1:10] <- c(1:10)/5
X <- MASS::mvrnorm(n,mu,Cov)
y = X\%*\%beta + rnorm(n)
test.set =c(30:50)
Est <-SIHR::QF(X = X, y = y, G = test.set)

}
\references{
\insertRef{grouplin}{SIHR}
}
