% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fitEllipse.R
\name{fitEllipse}
\alias{fitEllipse}
\title{Fit a multivariate normal distribution to x and y data using jags}
\usage{
fitEllipse(x, y, parms, priors)
}
\arguments{
\item{x}{a vector of data representing the x-axis}

\item{y}{a vector of data representing the y-axis}

\item{parms}{a list containing four items providing details of the
 \code{\link[rjags]{rjags}} run to be sampled.
\itemize{
   \item {n.iter}{The number of iterations to sample}
   \item {n.burnin}{The number of iterations to discard as a burnin from the
                     start of sampling.}
   \item {n.thin}{The number of samples to thin by.}
   \item {n.chains}{The number of chains to fit.}
}}

\item{priors}{a list of three items specifying the priors to be passed to
the jags model.
\itemize{
   \item {R}{The scaling vector for the diagonal of Inverse Wishart
   distribution prior on the covariance matrix Sigma. Typically
   set to a 2x2 matrix matrix(c(1, 0, 0, 1), 2, 2).}
   \item {k}{The degrees of freedom of the Inverse Wishart distribution for
   the covariance matrix Sigma. Typically set to the dimensionality of Sigma,
   which in this bivariate case is 2.}
   \item {tau}{The precision on the normal prior on the means mu.}
}}
}
\value{
A mcmc.list object of posterior samples created by jags.
}
\description{
This function contains and defines the jags model script used to fit a
bivariate normal distribution to a vector of x and y data. Although not
intended for direct calling by users, it presents a quick way to fit a model
to a single group of data. Advanced users should be able to manipulate the
contained jags model to fit more complex models using different likelihoods,
such as multivariate lognormal distributions, multivariate gamma
distributions etc...
}
\examples{
x <- stats::rnorm(50)
y <- stats::rnorm(50)
parms <- list()
parms$n.iter <- 2 * 10^3
parms$n.burnin <- 500
parms$n.thin <- 2
parms$n.chains <- 2
priors <- list()
priors$R <- 1 * diag(2)
priors$k <- 2
priors$tau.mu <- 1.0E-3
fitEllipse(x, y, parms, priors)
}

