% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_stations.R
\name{check_nominal_station}
\alias{check_nominal_station}
\title{Check if stations are reported as nominal positions}
\usage{
check_nominal_station(data, verbose = TRUE)
}
\arguments{
\item{data}{A data frame containing at least the columns:
\code{sample_date}, \code{station_name},
\code{sample_longitude_dd}, and \code{sample_latitude_dd}.}

\item{verbose}{Logical. If TRUE, messages will be displayed during execution. Defaults to TRUE.}
}
\value{
A data frame with distinct station names and their corresponding
latitude/longitude positions, if nominal positions are suspected.
Otherwise, returns \code{NULL}.
}
\description{
This function attempts to determine whether stations in a dataset are reported
using nominal positions (i.e., generic or repeated coordinates across events),
rather than actual measured coordinates.
}
\details{
The function compares the number of unique sampling dates with the number of
unique station coordinates.

If the number of unique sampling dates is larger than the number of unique
station coordinates, the function suspects nominal station positions and
issues a warning.
}
\examples{
df <- data.frame(
  sample_date = rep(seq.Date(Sys.Date(), by = "day", length.out = 3), each = 2),
  station_name = rep(c("ST1", "ST2"), 3),
  sample_longitude_dd = rep(c(15.0, 16.0), 3),
  sample_latitude_dd = rep(c(58.5, 58.6), 3)
)
check_nominal_station(df)

}
