% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Landscape-Methods.R
\name{simulateInitialPartition}
\alias{simulateInitialPartition}
\title{simulateInitialPartition Method}
\usage{
simulateInitialPartition(n = 500, prop = 0.4, range = 10, xmin = 0,
  xmax = 5000, ymin = 0, ymax = 5000)
}
\arguments{
\item{n}{Numeric, numbers of fields}

\item{prop}{Numeric [0,1] toxic fields proportion}

\item{range}{aggregation parameter (range of the spatial Exponential covariance of Gaussian process)}

\item{xmin}{x-axis left coordinates}

\item{xmax}{x-axis right coordinates}

\item{ymin}{y-axis bottom coordinates}

\item{ymax}{y-axis top coordinates}
}
\value{
An S4 \code{Landscape} object with \code{n} fields, \code{prop} pourcentage of toxic fields of size (xmin,xmax) (ymin,ymax)
}
\description{
This function creates an object \code{Landscape} and simulates a landscape with neutral and source fields.
}
\examples{
# simulate a 5000m x 5000m landscape with 500 fields whose 40\% (200) are sources
  simulateInitialPartition(n=500,prop=0.4,range=10,xmin=0,xmax=5000,ymin=0,ymax=5000)
}

