% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sdrawSample.R
\name{plotSample}
\alias{plotSample}
\title{Plot sample and frame}
\usage{
plotSample(x, frame, lattice = FALSE, bbox = FALSE, add = FALSE,
  poly.fill = TRUE)
}
\arguments{
\item{x}{A \code{SpatialPointsDataFrame} produced by an SDraw sampling function.  For example, 
as produced by \code{sdraw(frame,n)}.  This object is a standard \code{Spatial} \code{Polygons}\code{DataFrame} object
with additional attributes that record the sampling design.}

\item{frame}{The sample frame used to draw the sample contained in \code{x}. This is 
either a \code{SpatialPoints*}, \code{SpatialLines*}, or \code{SpatialPolygons*} object.}

\item{lattice}{Logical. Whether to plot the Halton Lattice if \code{x} is a HAL sample.}

\item{bbox}{Logical. Whether to plot the bounding box if the sample 
has a bounding box attribute. This generally means \code{x} 
is a HAL or BAS sample.  \code{lattice==TRUE} sets \code{bbox == TRUE}.}

\item{add}{Logical. Whether to add to an existing plot.  See Examples.}

\item{poly.fill}{Logical. Whether to fill polygons (TRUE) or leave them transparent (FALSE). 
Only applies to \code{SpatialPolygon*} frames.}
}
\value{
Nothing (NULL is invisibly returned)
}
\description{
Plot the sample and optionally the frame, background image (terrain), and lattice 
 (if HAL sample).
}
\examples{
data(WY)
samp <- sdraw(WY, 100, type="HIP", J=c(4,3))
plotSample( samp, WY )
plotSample( samp, WY, lattice=TRUE )

# A map-like background under frame and sample ----
# Requires 'OpenStreetMap' package and internet connection
\dontrun{
library(OpenStreetMap)
# 1:convert to Lat-Long
WY.ll <- spTransform(WY, CRS("+init=epsg:4326"))
# 2:Specify bounding box for OpenStreetMap
bb.openmap <- bbox(WY.ll)
ULcoords <- c(bb.openmap[2,2], bb.openmap[1,1])
BRcoords <- c(bb.openmap[2,1], bb.openmap[1,2])
# 3:Fetch image (see 'openmap' help for 'type' parameter)
openMap <- OpenStreetMap::openmap(ULcoords, BRcoords, type = "esri")
# 4:Project background image to original coordinate system
openMap <- OpenStreetMap::openproj(openMap, projection = CRS(proj4string(WY))) 
# 5:plot background
plot(openMap)
# 6:plot frame and sample
plotSample(samp, WY, add=TRUE, poly.fill=FALSE)
}
}
\seealso{
\code{\link{sdraw}}
}
\author{
Trent McDonald
}
