#' Data from a Sample of Divorce Records 
#'
#' Data from a sample of divorce records for states in the
#' Divorce Registration Area (National Center for Health Statistics 1987)
#' @name divorce
#' @docType data
#' @format Data frame with the following 20 variables: 
#' \describe{
#'   \item{state}{state name}
#'   \item{abbrev}{state abbreviation}
#'   \item{samprate}{sampling rate for state}
#'   \item{numrecs}{number of records sampled in state}
#'   \item{hsblt20}{number of records in sample with husband's age < 20}
#'   \item{hsb2024}{number of records with 20 <= husband's age <= 24}
#'   \item{hsb2529}{number of records with 25 <= husband's age <= 29}
#'   \item{hsb3034}{number of records with 30 <= husband's age <= 34}
#'   \item{hsb3539}{number of records with 35 <= husband's age <= 39}
#'   \item{hsb4044}{number of records with 40 <= husband's age <= 44}
#'   \item{hsb4549}{number of records with 45 <= husband's age <= 49}
#'   \item{hsbge50}{number of records with wife's age >= 50}
#'   \item{wflt20}{number of records in sample with wife's age < 20}
#'   \item{wf2024}{number of records with 20 <= wife's age <= 24}
#'   \item{wf2529}{number of records with 25 <= wife's age <= 29}
#'   \item{wf3034}{number of records with 30 <= wife's age <= 34}
#'   \item{wf3539}{number of records with 35 <= wife's age <= 39}
#'   \item{wf4044}{number of records with 40 <= wife's age <= 44}
#'   \item{wf4549}{number of records with 45 <= wife's age <= 49}
#'   \item{wfge50}{number of records with wife's age >= 50}
#' }   
#' @source National Center of Health Statistics (1987). TODO
#' @references Lohr (1999). Sampling: Design and Analysis, Duxbury, p. TODO and
#'   440. 
#' @export
roxygen()
