% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{auc}
\alias{auc}
\title{AUC}
\usage{
auc(model, test = NULL)
}
\arguments{
\item{model}{An \linkS4class{SDMmodel} or \linkS4class{SDMmodelCV} object.}

\item{test}{\linkS4class{SWD} object when \code{model} is an
\linkS4class{SDMmodel} object; logical or \linkS4class{SWD} object when
\code{model} is an \linkS4class{SDMmodelCV} object. If not provided it computes
the training AUC, see details.}
}
\value{
The value of the AUC.
}
\description{
Compute the AUC using the Man-Whitney U Test formula.
}
\details{
For \linkS4class{SDMmodelCV} objects, the function computes the mean
of the training AUC values of the k-folds. If \code{test = TRUE} it computes the
mean of the testing AUC values for the k-folds. If test is an
\linkS4class{SWD} object, it computes the mean AUC values for the provided
testing dataset.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd",
                    full.names = TRUE)

predictors <- terra::rast(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species",
                   p = p_coords,
                   a = bg_coords,
                   env = predictors,
                   categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data,
                         test = 0.2,
                         only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet",
               data = train,
               fc = "l")

# Compute the training AUC
auc(model)

# Compute the testing AUC
auc(model,
    test = test)
\donttest{
# Same example but using cross validation instead of training and testing
# datasets
folds <- randomFolds(data,
                     k = 4,
                     only_presence = TRUE)

model <- train(method = "Maxnet",
               data = data,
               fc = "l",
               folds = folds)

# Compute the training AUC
auc(model)

# Compute the testing AUC
auc(model,
    test = TRUE)

# Compute the AUC for the held apart testing dataset
auc(model,
    test = test)}
}
\references{
Mason, S. J. and Graham, N. E. (2002), Areas beneath the relative
operating characteristics (ROC) and relative operating levels (ROL) curves:
Statistical significance and interpretation. Q.J.R. Meteorol. Soc., 128:
2145-2166.
}
\seealso{
\link{aicc} and \link{tss}.
}
\author{
Sergio Vignali
}
