% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmax.R
\name{vmax}
\alias{vmax}
\title{Maximum linear speed}
\usage{
vmax(sdata, qi = 5, method = "ML", prob = 0.99, ...)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
See the data \code{\link{turtle}} for an example.
The function filters the input data by a unique "id" (e.g. transmitter number, identifier for each animal). 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} 
or \code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"lat" and "lon" are the latitude and longitude of each location in decimal degrees. 
"qi" is the quality index associated with each location fix. 
The input values can be either the number of GPS satellites or Argos Location Classes. 
Argos Location Classes will be converted to numerical values, where "A", "B", "Z" will be replaced with "-1", "-2", "-3" respectively.
The greater number indicates a higher accuracy.}

\item{qi}{An integer specifying the lowest quality index of a location that is qualified to be used in the estimation. 
Default is 5 (e.g. 5 GPS satellite or more).}

\item{method}{Available options are "sample" (i.e. sample quantile - see \code{\link[stats:quantile]{quantile}})
and "ML" (maximum likelihood estimation). Default is "ML". See details.}

\item{prob}{A value (0 to 1) specifying the sample quantile or cumulative probability for linear speed.
Values beyond this threshold are considered 'outliers' and excluded from estimation of maximum linear speed. 
Default is 0.99. See details.}

\item{...}{Extra arguments passed to \code{\link{dupfilter}}.}
}
\value{
Maximum linear speed (vmax) estimated from the input data. The unit is km/h.
}
\description{
Function to estimate the maximum linear speed between two consecutive locations.
}
\details{
The function first calculates the linear speed between each pair of two consecutive locations. 
Some of the calculated linear speed can be inaccurate when the input data contains inaccurate locations (e.g. outliers).
The function can discard the implausible outliers by excluding extreme values using either the "sample" or "ML" method.
The "sample" method simply discards values that lie beyond the specified quantile. 
If the "ML" method is selected, it is assumed that the linear speed follow a Gamma distribution. 
The distribution parameters are derived via maximum likelihood estimation using the \code{\link[stats:optim]{optim}} function. 
The linear speed at the given quantile or cumulative probability (e.g. 0.99) represents the maximum linear speed at which 
an animal would travel between two consecutive locations.
}
\references{
Shimada T, Jones R, Limpus C, Hamann M (2012) 
Improving data retention and home range estimates by data-driven screening. 
\emph{Marine Ecology Progress Series} 457:171-180 \doi{10.3354/meps09747}
}
\seealso{
\code{\link{ddfilter}}, \code{\link{ddfilter_speed}}, \code{\link{track_param}}, \code{\link{dupfilter}}
}
\author{
Takahiro Shimada
}
