% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_importances.R
\name{gene_importances}
\alias{gene_importances}
\title{Calculate the importance of a feature}
\usage{
gene_importances(
  x,
  time,
  num_permutations = 0,
  ntree = 10000,
  ntree_perm = ntree/10,
  mtry = ncol(x) * 0.01,
  num_threads = 1,
  ...
)
}
\arguments{
\item{x}{A numeric matrix or a data frame with \emph{M} rows (one per sample) and \emph{P} columns (one per feature).}

\item{time}{A numeric vector containing the inferred time points of each sample along a trajectory as returned by \code{\link{infer_trajectory}}.}

\item{num_permutations}{The number of permutations to test against for calculating the p-values (default: 0).}

\item{ntree}{The number of trees to grow (default: 10000).}

\item{ntree_perm}{The number of trees to grow for each of the permutations (default: ntree / 10).}

\item{mtry}{The number of variables randomly samples at each split (default: 1\% of features).}

\item{num_threads}{Number of threads. Default is 1.}

\item{...}{Extra parameters passed to \code{\link[ranger]{ranger}}.}
}
\value{
a data frame containing the importance of each feature for the given time line
}
\description{
Calculates the feature importance of each column in \code{x} in trying to predict the time ordering.
}
\examples{
dataset <- generate_dataset(num_genes=500, num_samples=300, num_groups=4)
expression <- dataset$expression
group_name <- dataset$sample_info$group_name
space <- reduce_dimensionality(expression, ndim=2)
traj <- infer_trajectory(space)
# set ntree to at least 1000!
gene_importances(expression, traj$time, num_permutations = 0, ntree = 1000)
}
