% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_shortcut.R
\name{Shortcut}
\alias{Shortcut}
\alias{Perfect}
\title{Assessment emulator as a shortcut to model fitting in closed-loop simulation}
\usage{
Shortcut(
  x = 1,
  Data,
  method = c("B", "N", "RF"),
  B_err = c(0.3, 0.7, 1),
  N_err = c(0.3, 0.7, 1),
  R_err = c(0.3, 0.7, 1),
  F_err = c(0.3, 0.7, 1),
  ...
)

Perfect(x, Data, ...)
}
\arguments{
\item{x}{An index for the objects in \code{Data} when running in \link[MSEtool]{runMSE}.
Otherwise, equals to 1 When running an assessment interactively.}

\item{Data}{An object of class Data.}

\item{method}{Indicates where the error in the OM is located. For "B", OM biomass is directly sampled with error.
For "N", OM abundance-at-age is sampled and biomass subsequently calculated. For "RF", recruitment and F are
sampled to calculate abundance and biomass. There is no error in biological parameters for "N" and "RF".}

\item{B_err}{If method = "B", a vector of length three that specifies the standard deviation (in logspace),
autocorrelation, and bias (1 = unbiased) for biomass.}

\item{N_err}{Same as B_err, but for abundance when method = "N".}

\item{R_err}{Same as B_err, but for recruitment when method = "RF".}

\item{F_err}{Same as B_err, but for fishing mortality when method = "RF".}

\item{...}{Other arguments (not currently used).}
}
\value{
An object of class \linkS4class{Assessment}.
}
\description{
Functions (class Assessment) that emulate a stock assessment by sampling the operating model biomass and abundance
(with observation error, autocorrelation, and bias) instead of fitting a model. This output can then
be passed onto a harvest control rule (HCR function). To utilize the shortcut method in closed-loop simulation,
use \link{make_MP} with \code{Shortcut} as the Assessment function. \code{Perfect} assumes no error in the 
assessment model and is useful for comparing the behavior of different harvest control rules.
}
\details{
Currently there is no error in FMSY (the target F in the HCR in SAMtool).

See Wiedenmann et al. (2015) for guidance on the magnitude of error for the shortcut emulator.
}
\examples{
Shortcut_4010 <- make_MP(Shortcut, HCR40_10) 
Shortcut_Nerr <- make_MP(Shortcut, HCR40_10, method = "N", N_err = c(0.1, 0.1, 1)) # Highly precise!

\donttest{
# Compare the shortcut method vs. fitting an SCA model with a 40-10 control rule
MSE <- runMSE(testOM, MPs = c("Shortcut_4010", "SCA_4010"))
}

# Compare the performance of three HCRs
Perfect_4010 <- make_MP(Perfect, HCR40_10)
Perfect_6020 <- make_MP(Perfect, HCR60_20)
Perfect_8040MSY <- make_MP(Perfect, HCR_ramp, OCP_type = "SSB_SSBMSY", TOCP = 0.8, LOCP = 0.4)

\donttest{
MSE <- runMSE(testOM, MPs = c("Perfect_4010", "Perfect_6020", "Perfect_8040MSY"))
}
}
\references{
Wiedenmann, J., Wilberg, M.J., Sylvia, A., and Miller, T.J. 2015. Autocorrelated error in stock assessment 
estimates: Implications for management strategy evaluation. Fisheries Research 172: 325-334.
}
\author{
Q. Huynh
}
