% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxrandom.R
\name{rxnorm}
\alias{rxnorm}
\alias{rxnormV}
\title{Simulate random normal variable from threefry/vandercorput generator}
\usage{
rxnorm(mean = 0, sd = 1, n = 1L, ncores = 1L)

rxnormV(mean = 0, sd = 1, n = 1L, ncores = 1L)
}
\arguments{
\item{mean}{vector of means.}

\item{sd}{vector of standard deviations.}

\item{n}{number of observations}

\item{ncores}{Number of cores for the simulation

\code{rxnorm} simulates using the threefry sitmo generator; \code{rxnormV}
uses the vandercorput generator}
}
\value{
normal random number deviates
}
\description{
Simulate random normal variable from threefry/vandercorput generator
}
\examples{
\donttest{
## Use threefry engine

rxnorm(n=10) # with rxnorm you have to explicitly state n
rxnorm(n=10,ncores=2) # You can parallelize the simulation using openMP

rxnorm(2,3) ## The first 2 arguments are the mean and standard deviation


## This example uses `rxnorm` directly in the model

rx <- RxODE({
  a = rxnorm()
})

et <- et(1,id=1:2)

s <- rxSolve(rx,et)

## Use vandercorput generator

rxnormV(n=10) # with rxnorm you have to explicitly state n
rxnormV(n=10,ncores=2) # You can parallelize the simulation using openMP

rxnormV(2,3) ## The first 2 arguments are the mean and standard deviation


## This example uses `rxnormV` directly in the model

rx <- RxODE({
  a = rxnormV()
})

et <- et(1,id=1:2)

s <- rxSolve(rx,et)
}
}
