% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variable.R
\name{plot_variable}
\alias{plot_variable}
\title{Plot path metrics.}
\usage{
plot_variable(
  variable,
  experiment,
  factor = NA,
  factor.colours = "auto",
  exclude.probe = FALSE,
  boundaries = NA,
  legend = TRUE,
  x.axis = "Day",
  titles = TRUE,
  margins = c(5, 4, 4, 8),
  ...
)
}
\arguments{
\item{variable}{The variable/metric that should be plotted. See Details for the ways to
specify this.}

\item{experiment}{The \code{rtrack_experiment} object as returned from
\code{\link{read_experiment}}.}

\item{factor}{The factor by which the data should be grouped. Each factor level will be
plotted as a separate series. If not specified, all values are plotted together in
one series.}

\item{factor.colours}{A colour to be used for each factor level. If not specified,
colours will be automatically generated. The vector of colours is returned to allow
additional plot customisation.}

\item{exclude.probe}{Should data from probe trials be excluded (see Details).}

\item{boundaries}{Where should the boundaries between arena types be drawn (see
Details).}

\item{legend}{Should a legend be added. Default is \code{TRUE}.}

\item{x.axis}{The scale of the x axis. Default, "Day", is to add a labelled axis with
tick marks at each day. If this parameter is set to "Trial", then tick marks are
added for each trial. If set to "none", then no x axis will be drawn.}

\item{titles}{Should titles be drawn. Default is to add a main title and titles for the
x and y axes. These can be supressed and added afterwards (using
\code{\link[graphics]{title}}). This might be helpful for localising to a different
language for example.}

\item{margins}{The margins of the plot (see the option \code{mar} in
\code{\link[graphics]{par}}). The defaults should usually be fine, but they can be
overridden if, for example, factor names are very long.}

\item{...}{Other parameters passed to \code{\link[graphics]{segments}} to control the
plotted lines.}
}
\value{
A named vector of colours used for each factor level.
}
\description{
Plots the metrics that have been calculated from path coordinates.
}
\details{
Many of the summary metrics (as returned in the \code{summary} component of
the \code{\link{calculate_metrics}} output are useful for analysis in their
own right. These can be plotted as mean values over each trial with standard
error bars. If a factor is provided, then one data series will be plotted for
each level of the factor. To view data for mutliple factors, they will need
to be collapsed into one composite factor for plotting using this function.
If probe trials were used, then 'latency to goal' and several other variables
do not make much sense, so the data for the probe trials can be suppressed.
For this to work, a column named 'Probe' must be present in the experiment
description spreadsheet and must contain the value 'TRUE' for each probe
trial.

The \code{variable} parameter can either be specified as the name of one of
the summary metrics, the name of one of the columns from the experiment
description, or as a numeric vector. In the latter case, the numeric vector
must be the same length as the number of tracks in the experiment.


Boundaries are drawn (as broken vertical lines) between different arena types
(for example between acquisition and goal reversal phases of a Morris water
maze experiment). By default, these are added between each unique arena
definition. If this is not appropriate, then this can be overridden by
providing the \code{boundaries} parameter with a \code{\link{data.frame}}
with two columns 'day' and 'trial'. Multiple boundaries can be defined by
entering the day and trial index into rows of this table. Use
\code{boundaries = NULL} to suppress boundary lines altogether.
}
\examples{
# This function relies on data too large to include in the package.
# For a worked example, please see the vignette "Rtrack MWM analysis".

}
