% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icesParsing.R
\name{parseInterCatch}
\alias{parseInterCatch}
\title{Parses InterCatch}
\usage{
parseInterCatch(file, encoding = "UTF-8")
}
\arguments{
\item{file}{path to file containing intercatch formatted data}

\item{encoding}{encoding of 'file'}
}
\value{
named list with three members:
\describe{
 \item{HI}{\code{\link[data.table]{data.table}} with HI records}
 \item{SI}{\code{\link[data.table]{data.table}} with SI records}
 \item{SD}{\code{\link[data.table]{data.table}} with SD records}
}
}
\description{
Parses the InterCatch exchange format v 1.0 for Commercial Catch and Sample Data.
}
\details{
The InterCatch exchange format is a jagged comma-separated format, 
 where the number of fields on a line is determined by a record-type identifier in position 1.
 Three record types are defined, "HI" (header information), "SI" (species information), and "SD" (species data).
 The format it specified on https://ices.dk/data/Documents/Intercatch/IC-ExchangeFormat1-0.pdf.
}
