% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-object.R
\name{create_tool}
\alias{create_tool}
\title{Generates list of options for a SAGA-GIS tool}
\usage{
create_tool(tool_information, tool_options, description, html_file)
}
\arguments{
\item{tool_information}{list}

\item{tool_options}{list}

\item{description}{the description text for the tool that has been scraped
from the help documentation}

\item{html_file}{the name of the html file for the tool's documentation.
Stored to help linking with online documentation.}
}
\value{
A `saga_tool` object containing:
+ `tool_name` A syntactically-correct name for the tool.
+ `description` The tool's description.
+ `author` The tool's author.
+ `tool_cmd` The command to use for saga_cmd to execute tool.
+ `tool_id` The tool's ID.
+ `parameters` A named list of the tool's parameter objects.
+ `html_file` The html document name.
}
\description{
Parses the html table for a SAGA-GIS tool into a list of identifiers,
options, defaults and constraints
}
\keyword{internal}
