\name{D.discretize.equal.intervals.RST}
\alias{D.discretize.equal.intervals.RST}
\title{The "equal interval size" discretization algorithm}
\usage{
  D.discretize.equal.intervals.RST(decision.table,
    nOfIntervals = 4, ...)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{nOfIntervals}{a numeric value representing the
  number of interval separating the data.}

  \item{...}{other parameters.}
}
\value{
  A class \code{"Discretization"} that contains the
  following components: \itemize{ \item \code{cut.values}:
  a list representing cut values of each considered
  attributes. \item \code{type.method}: the type of method
  which is used to define cut values.

  In this case, it is \code{"unsupervised.intervals"}.
  \item \code{type.task}: the type of task which is
  \code{"discretization"}. \item \code{model}: the type of
  model which is \code{"RST"}. }
}
\description{
  It is a function used for computing cuts of the "equal
  interval size" discretization into \eqn{k} intervals
}
\details{
  This method can be considered an unsupervised
  discretization method for continuous features since it
  does not consider the class label. The algorithm starts
  by sorting the data and then we calculate \eqn{\delta}
  defined as

  \eqn{\delta = \frac{x_{max} - x_{min}}{k}},

  where \eqn{k} is a parameter supplied by the user to
  define how many intervals will be determined and
  \eqn{x_{max}} and \eqn{x_{min}} are the upper and lower
  boundary of data. The detailed information can be seen in
  (J. Dougherty et al, 1995).

  It should be noted that the output of this function is a
  class containing cut values. In order to generate the new
  decision table, \code{\link{SF.applyDecTable}} should be
  executed.
}
\examples{
#################################################################
## Example: Determine cut values and generate new decision table
#################################################################
 dt.ex1 <- data.frame(c(1, 1.2, 1.3, 1.4, 1.4, 1.6, 1.3), c(2, 0.5, 3, 1, 2, 3, 1),
                             c(1, 0, 0, 1, 0, 1, 1))
colnames(dt.ex1) <- c("a", "b", "d")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 3,
                                     indx.nominal = c(3))

cut.values <- D.discretize.equal.intervals.RST(decision.table, nOfIntervals = 4)

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, cut.values)
}
\references{
  J. Dougherty, R. Kohavi, and M. Sahami, "Supervised and
  Unsupervised Discretization of Continuous Features", In
  A. Prieditis & S. J. Russell, eds. Work. Morgan Kaufmann,
  p. 194-202 (1995).
}
\seealso{
  \code{\link{D.local.discernibility.matrix.RST}},
  \code{\link{D.max.discernibility.matrix.RST}},

  \code{\link{D.discretize.quantiles.RST}}, and
  \code{\link{D.global.discernibility.heuristic.RST}}
}

