% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/place_order_options.R
\name{place_order_options}
\alias{place_order_options}
\title{Place a options buy or sell order against your RobinHood account}
\usage{
place_order_options(
  RH,
  option_id,
  direction,
  side,
  quantity,
  stop_price = NULL,
  type = "limit",
  time_in_force
)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{option_id}{(string) id returned from get_contracts()}

\item{direction}{(string) one of "debit" or "credit"}

\item{side}{(string) one of "buy" or "sell"}

\item{quantity}{(integer) number of contracts to buy}

\item{stop_price}{(numeric) stop price for a limit order}

\item{type}{(string) "limit" or "market" (only limit is currently supported)}

\item{time_in_force}{(string) Good Till Canceled ("gtc"), Immediate or Cancel ("ioc"), or Opening ("opg")}
}
\description{
Place an order on an option contract. Currently only limit orders are supported so you must supply a price
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

# Place an options order, should generate an email confirmation
x <- place_order_options(RH = RH,
                       option_id = "346e46af-380e-4052-a7c2-15748f0fc0ca",
                       direction = "debit",   # one of "debit" or "credit"
                       side = "buy",          # one of "buy" or "sell"
                       quantity = 1,          # number of contracts
                       stop_price = .01,      # Time period (gfd: good for day)
                       type = "limit",        # limit or market (only limit is currently supported)
                       time_in_force = "gtc") # "gfd", "gtc", "ioc", "opg"
}
}
